% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{simplify_simple}
\alias{simplify_simple}
\title{Convert a list to an atomic vector if it consists solely of atomic elements of length 1.}
\usage{
simplify_simple(
  x,
  toNA = c("null", "empty", "keep"),
  empty = c("keep", "unlist"),
  ...
)
}
\arguments{
\item{x}{an R \code{\link{list}} to be simplified.}

\item{toNA}{a character string indicating whether \code{NULL} entries
(if \code{"null"}) or 0-length entries including \code{NULL} (if \code{"empty"})
should be replaced with \code{NA}s before attempting conversion;
specifying \code{keep} or \code{FALSE} leaves them alone (typically
preventing conversion).}

\item{empty}{a character string indicating how empty lists should
be handled: either \code{"keep"}, in which case they are unchanged or
\code{"unlist"}, in which cases they are unlisted (typically to
\code{NULL}).}

\item{...}{additional arguments passed to \code{\link[=unlist]{unlist()}}.}
}
\value{
an atomic vector or a list of the same length as \code{x}.
}
\description{
This behaviour is not dissimilar to that of \code{\link[=simplify2array]{simplify2array()}}, but
it offers more robust handling of empty or NULL elements and never
promotes to a matrix or an array, making it suitable to be a column
of a \code{\link{data.frame}}.
}
\examples{

(x <- as.list(1:5))
stopifnot(identical(simplify_simple(x), 1:5))

x[3] <- list(NULL) # Put a NULL in place of 3.
x
stopifnot(identical(simplify_simple(x, FALSE), x)) # Can't be simplified without replacing the NULL.

stopifnot(identical(simplify_simple(x), c(1L,2L,NA,4L,5L))) # NULL replaced by NA and simplified.

x[[3]] <- integer(0)
x
stopifnot(identical(simplify_simple(x), x)) # A 0-length vector is not replaced by default,
stopifnot(identical(simplify_simple(x, "empty"), c(1L,2L,NA,4L,5L))) # but can be.

(x <- lapply(1:5, function(i) c(i,i+1L))) # Elements are vectors of equal length.
simplify2array(x) # simplify2array() creates a matrix,
stopifnot(identical(simplify_simple(x), x)) # but simplify_simple() returns a list.

}
