# Announce: Rakudo Perl 6 compiler, Development Release #86 (“Cluj”)

On behalf of the Rakudo development team, I’m happy to announce the March
2015 release of Rakudo Perl 6 #86 “Cluj”. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine. The
tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^3] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

As described by pmichaud in a recent blog post:

  http://pmthium.com/2015/02/suspending-rakudo-parrot/

this is the first release of Rakudo that does *not* support Parrot [^2] as a
backend.  Whether Parrot support can be restored at some point in the future,
really depends on people with tuits making the necessary changes.  In that
light, I would like to emphasize the last paragraph of said blog post:

    If there are people that want to work on refactoring Rakudo’s support
    for Parrot so that it’s more consistent with the other VMs, we can
    certainly point them in the right direction. For the GLR this will
    mainly consists of migrating parrot-specific code from Rakudo into
    NQP’s APIs. For the NSA and NFG work, it will involve developing a lot
    of new code and feature capabilities that Parrot doesn’t possess.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This release is named after
Cluj.pm which just celebrated its third birthday.

Some of the changes in this release are outlined below:

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

+ Incompatible changes and deprecations:
  + renamed internal hash/array/code/* methods:

    | OLD                  | NEW                |
    |----------------------|--------------------|
    | at_pos               | AT-POS             |
    | exists_pos           | EXISTS-POS         |
    | delete_pos           | DELETE-POS         |
    | assign_pos           | ASSIGN-POS         |
    | bind_pos             | BIND-POS           |
    | at_key               | AT-KEY             |
    | exists_key           | EXISTS-KEY         |
    | delete_key           | DELETE-KEY         |
    | assign_key           | ASSIGN-KEY         |
    | bind_key             | BIND-KEY           |
    | invoke               | CALL-ME            |
    | Supply.on_demand     | Supply.on-demand   |
    | Supply.schedule_on   | Supply.schedule-on |

  + renamed traits
    - hidden_from_backtrace  hidden-from-backtrace
    - hidden_from_USAGE      hidden-from-USAGE
  + Deprecated use MONKEY_TYPING for use MONKEY-TYPING.
  + Deprecate IO::Handle.input-line-separator for .nl
+ Features
  + Allow Buf.AT-POS to return an l-value.
  + Implement method ^foo($) { ... } syntax.
  + Implemented PairMap (the simple case only, for now).
  + Implemented .antipairs (pairs with value => key).
  + Implemented .pairup for creating pairs from lists.
  + Implemented LEXICAL, OUTERS and CALLERS pseudo-packages
  + Add a array[T], usable for native int/num (MoarVM only for now)
  + Other native improvements, e.g. my int $a; $a++
  + Implement IO::Path.resolve on r-m/POSIX
+ Fixes
  + Fix JVM runner generation on Windows.
  + Make $?TABSTOP immutable
  + Make CALLER::<&?ROUTINE> work
  + Errors like "expected Array[Str] but got Array[Str]" have been fixed.
+ Optimizations
  + Make my int/num @a = Range about 1000x faster
  + Make s/// up to 25% faster
  + Make substr(-rw) about 10% faster
+ Test.pm changes
  + Add simple use-ok implementation
+ NativeCall.pm changes
  + 'is native' will also accept Callables to allow runtime library detection
  + Implemented nativesizeof(T)
  + Add typed Pointer type as replacement for OpaquePointer

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:
Elizabeth Mattijsen, Jonathan Worthington, Larry Wall, Tobias Leich, ugexe,
Alexander Moquin, Moritz Lenz, Timo Paulssen, Pepe Schwarz, Andrew Egeler,
Christian Bartolomäus, Kamil Kułaga, Solomon Foster, Geoffrey Broadwell,
Jonathan Scott Duff, Paul Cochrane, Carl Masak, Will "Coke" Coleda, raydiak,
Donald Hunter, Stefan Seifert, Rob Hoelz, sue spence, Brad Gilbert, Ven,
Steve Mynott, [Tux], Nicholas Clark, avuserow

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC #perl6
on freenode.

The next release of Rakudo (#87), is scheduled for 23 April 2015.
A list of the other planned release dates and code names for future
releases is available in the “docs/release_guide.pod” file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: See <http://parrot.org/>

[^3]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
