// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from BulkRequest.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.bulkrpc {
  public class BulkRequest : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("bulkrpc.BulkRequest:1.0.0", null);

    public BulkRequest(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public BulkRequest(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new BulkRequest StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new BulkRequest(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class PerformRequestResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkrpc.Response> responses;
    }

    public PerformRequestResult performRequest(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkrpc.Request> requests) {
      var _parameters = new LightJson.JsonObject();
      _parameters["requests"] = new JsonArray(requests.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("performRequest", _parameters);
      var _ret = new PerformRequestResult();
      _ret.responses = new System.Collections.Generic.List<Com.Raritan.Idl.bulkrpc.Response>(_result["responses"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.bulkrpc.Response.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest performRequest(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkrpc.Request> requests, AsyncRpcResponse<PerformRequestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return performRequest(requests, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest performRequest(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.bulkrpc.Request> requests, AsyncRpcResponse<PerformRequestResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["requests"] = new JsonArray(requests.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("performRequest", _parameters,
        _result => {
          try {
            var _ret = new PerformRequestResult();
            _ret.responses = new System.Collections.Generic.List<Com.Raritan.Idl.bulkrpc.Response>(_result["responses"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.bulkrpc.Response.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
