package org.jboss.resteasy.test.resource.param.resource;

import org.jboss.resteasy.test.resource.param.QueryParamAsPrimitiveTest;
import org.junit.Assert;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path("/default")
public class QueryParamAsPrimitiveResourceDefault {
   @GET
   @Produces("application/boolean")
   public String doGet(@QueryParam("boolean") @DefaultValue("true") boolean v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, true, v);
      return "content";
   }

   @GET
   @Produces("application/byte")
   public String doGet(@QueryParam("byte") @DefaultValue("127") byte v) {
      Assert.assertTrue((byte) 127 == v);
      return "content";
   }

   @GET
   @Produces("application/short")
   public String doGet(@QueryParam("short") @DefaultValue("32767") short v) {
      Assert.assertTrue((short) 32767 == v);
      return "content";
   }

   @GET
   @Produces("application/int")
   public String doGet(@QueryParam("int") @DefaultValue("2147483647") int v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, 2147483647, v);
      return "content";
   }

   @GET
   @Produces("application/long")
   public String doGet(@QueryParam("long") @DefaultValue("9223372036854775807") long v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, 9223372036854775807L, v);
      return "content";
   }

   @GET
   @Produces("application/float")
   public String doGet(@QueryParam("float") @DefaultValue("3.14159265") float v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, 3.14159265f, v, 0.0f);
      return "content";
   }

   @GET
   @Produces("application/double")
   public String doGet(@QueryParam("double") @DefaultValue("3.14159265358979") double v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, 3.14159265358979d, v, 0.0);
      return "content";
   }
    
   @GET
   @Produces("application/char")
   public String doGet(@QueryParam("char") @DefaultValue("a") char v) {
      Assert.assertEquals(QueryParamAsPrimitiveTest.ERROR_MESSAGE, 'a', v);
      return "content";
   }
}
