/*
 * Copyright (C) 2024-2025 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */
#ifndef HAVE_XITK_CFG_PARSE_H
#define HAVE_XITK_CFG_PARSE_H

/* this will pad the return with 8 zero bytes both before and after.
 * filesize, if set, is the size limit before and the actual size after the call. */
char *xitk_cfg_load (const char *filename, size_t *filesize);
void xitk_cfg_unload (char *buf);

/* a simple trimmed line iterator (eg xinerc file). init next to the return of xitk_cfg_load (). */
char *xitk_cfg_next_line (char **next);

typedef struct {
  /* 0 for root node tree[0] */
  short int level;
  /* byte length of key */
  unsigned short int klen;
  /* array index. */
  int next, prev, parent, first_child, last_child;
  /* root node: total count of nodes.
   * otherwise: offset into contents, converted to lowercase, or -1. */
  int key;
  /* offset into contents, or -1. */
  int value;
} xitk_cfg_parse_t;

#define XITK_CFG_PARSE_DEBUG 1 /* show extra info */
#define XITK_CFG_PARSE_CASE 2 /* dont lowercase keys */
xitk_cfg_parse_t *xitk_cfg_parse (char *contents, int flags);
void xitk_cfg_unparse (xitk_cfg_parse_t *tree);

#endif
