/*
    Copyright (C) 2020 Fredrik Johansson

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include "ca_vec.h"
#include "ca_mat.h"
#include "gr.h"
#include "gr_mat.h"

void
ca_mat_det_cofactor(ca_t res, const ca_mat_t A, ca_ctx_t ctx)
{
    gr_ctx_t gr_ctx;
    _gr_ctx_init_ca_from_ref(gr_ctx, GR_CTX_CC_CA, ctx);

    GR_MUST_SUCCEED(gr_mat_det_cofactor(res, (const gr_mat_struct *) A, gr_ctx));
}
