/// <reference types="node" />
import { CaseType, Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
import * as GeneralGlyph from "../general-glyph";
import * as Lib_General_Point from "../general-glyph/point/ref";
import * as TAG_GeometryType from "../general-glyph/type-tags/geometry-type";
import * as TAG_HintType from "../general-glyph/type-tags/hint-type";
import * as OtGlyphCoStat from "./co-stat";
import * as Lib_Point from "./point";
import * as OtGlyphStat from "./stat";
export declare class OtGlyph {
    name?: string;
    horizontal: GeneralGlyph.Metric.T<OtVar.Value>;
    vertical: GeneralGlyph.Metric.T<OtVar.Value>;
    geometry: Data.Maybe<OtGlyph.Geometry>;
    hints: Data.Maybe<OtGlyph.Hint>;
    static shallowCopy(g: OtGlyph): OtGlyph;
}
export declare namespace OtGlyph {
    type Geometry = ContourSet | TtReference | GeometryList;
    type ContourSetProps = GeneralGlyph.ContourSetPropsT<OtVar.Value>;
    type ContourSet = CaseType<typeof TAG_GeometryType.ContourSet, ContourSetProps>;
    const ContourSet: import("@ot-builder/prelude").CaseClassType<typeof GeometryType.ContourSet, ContourSetProps, [contours?: Contour[] | undefined]>;
    type GeometryListProps = GeneralGlyph.GeometryListPropsT<Geometry>;
    type GeometryList = CaseType<typeof TAG_GeometryType.GeometryList, GeometryListProps>;
    const GeometryList: import("@ot-builder/prelude").CaseClassType<typeof GeometryType.GeometryList, GeometryListProps, [items?: Geometry[] | undefined]>;
    type TtReferenceProps = GeneralGlyph.TtReferencePropsT<OtGlyph, OtVar.Value>;
    type TtReference = CaseType<typeof TAG_GeometryType.TtReference, TtReferenceProps>;
    const TtReference: import("@ot-builder/prelude").CaseClassType<typeof GeometryType.TtReference, TtReferenceProps, [to: OtGlyph, transform: Transform2X3]>;
    type Hint = TtInstruction | CffHint;
    type TtInstructionProps = GeneralGlyph.TtInstructionPropsT<OtVar.Value>;
    type TtInstruction = CaseType<typeof TAG_HintType.TtInstruction, TtInstructionProps>;
    const TtInstruction: import("@ot-builder/prelude").CaseClassType<typeof HintType.TtInstruction, TtInstructionProps, [instructions: Buffer]>;
    type CffHintProps = GeneralGlyph.CffHintPropsT<OtVar.Value>;
    type CffHint = CaseType<typeof TAG_HintType.CffHint, CffHintProps>;
    type CffHintStem = GeneralGlyph.CffHintStemT<OtVar.Value>;
    type CffHintMask = GeneralGlyph.CffHintMaskT<OtVar.Value>;
    const CffHint: import("@ot-builder/prelude").CaseClassType<typeof HintType.CffHint, CffHintProps, []> & {
        createStem(start: OtVar.Value, end: OtVar.Value): CffHintStem;
        createMask(at: PointRef, maskH: Set<CffHintStem>, maskV: Set<CffHintStem>): CffHintMask;
    };
    export import PointType = Lib_Point.PointType;
    type Point = GeneralGlyph.Point.T<OtVar.Value>;
    namespace Point {
        function create(x: OtVar.Value, y: OtVar.Value, kind?: number): Point;
    }
    export import PointOps = Lib_Point.PointOps;
    type Contour = GeneralGlyph.Contour.T<OtVar.Value>;
    export import PointIDRef = Lib_General_Point.PointIDRef;
    type GlyphPointIDRef = Lib_General_Point.GlyphPointIDRef<OtGlyph>;
    export import PointRef = Lib_General_Point.PointRef;
    export import PointRefW = Lib_General_Point.PointRefW;
    export import PointAttachment = Lib_General_Point.PointAttachment;
    type Metric = GeneralGlyph.Metric.T<OtVar.Value>;
    type Transform2X3 = GeneralGlyph.Transform2X3.T<OtVar.Value>;
    namespace Transform2X3 {
        const Identity: Transform2X3;
        function Scale(s: number): Transform2X3;
        function Translate(dx: OtVar.Value, dy: OtVar.Value): Transform2X3;
        function Rotate(angle: number): Transform2X3;
    }
    export import Stat = OtGlyphStat;
    export import CoStat = OtGlyphCoStat;
    export import GeometryType = TAG_GeometryType;
    export import HintType = TAG_HintType;
}
//# sourceMappingURL=index.d.ts.map