"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Phony = Phony;
const interface_1 = require("../core/interface");
const rule_base_1 = require("./rule-base");
const util_1 = require("./util");
class PhonyRule extends rule_base_1.RuleBase {
    constructor(matcher, FRecipe) {
        super(matcher);
        this.FRecipe = FRecipe;
        this.kindTag = "Builtin::PhonyRule";
    }
    async build(t, ...args) {
        const result = await this.FRecipe(t, ...args);
        t.is.modified();
        return result;
    }
    async preBuild(t) {
        return interface_1.PreBuildResult.YES;
    }
    async shouldTriggerModify(t, itselfModified) {
        return itselfModified;
    }
}
function Phony(dir) {
    const _phony = (0, util_1.SinglePlural_T)("Builtin::Phony::", dir, (matcher, FRecipe) => new PhonyRule(matcher, FRecipe));
    return {
        phony: Object.assign(_phony.exact, {
            glob: _phony.glob,
            group: _phony.subPrefix,
            make: _phony.make,
        }),
    };
}
