#*************************************************************************
#**
#**    This file is part of the 'forwords' educational programm.
#**    Copyright (C) 2024  Alexander Fomin
#**
#**    This program is free software: you can redistribute it and/or modify
#**    it under the terms of the GNU General Public License as published by
#**    the Free Software Foundation, either version 3 of the License, or
#**    (at your option) any later version.
#**
#**    This program is distributed in the hope that it will be useful,
#**    but WITHOUT ANY WARRANTY; without even the implied warranty of
#**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#**    GNU General Public License for more details.
#**
#**    You should have received a copy of the GNU General Public License
#**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
#**
#**    Contact: fomin_alex@yahoo.com
#**
#**************************************************************************

QT       += core gui \
            widgets \
            webenginewidgets

greaterThan(QT_MAJOR_VERSION, 5): QT += widgets

TARGET = forwords
TEMPLATE = app

# The following define makes your compiler emit warnings if you use
# any feature of Qt which has been marked as deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if you use deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0

CONFIG += c++latest

SOURCES += \
    src/dlgedit.cpp \
    src/dlgsettings.cpp \
    src/dlgtest1.cpp \
    src/dlgtest3.cpp \
    src/forwords.cpp \
    src/main.cpp \
    src/tts.cpp

HEADERS += \
    src/common.h \
    src/dlgedit.h \
    src/dlgsettings.h \
    src/dlgtest1.h \
    src/dlgtest3.h \
    src/forwords.h \
    src/tts.h

FORMS += \
    src/dlgedit.ui \
    src/dlgsettings.ui \
    src/dlgtest1.ui \
    src/dlgtest3.ui \
    src/forwords.ui

PREFIX = /usr/local

# all necessary files installation settings
documentation.path = $$(PREFIX)/share/doc/forwords
documentation.files = docs/*
documentation.files +=     AUTHORS \
                            COPYING \
                            INSTALL \
                            README \
                            TODO

manpage.path = $$(PREFIX)/share/man/man1
manpage.files = forwords.1.gz

icon.path = $$(PREFIX)/share/icons/hicolor/128x128/apps
icon.files = icons/*

desktopfile.path = $$(PREFIX)/share/applications
desktopfile.files = forwords.desktop

translationfiles.path = $$(PREFIX)/share/forwords/translations
translationfiles.files = translations/*

metainfo.path = $$(PREFIX)/share/metainfo
metainfo.files = forwords.metainfo.xml

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = $$(PREFIX)/bin
!isEmpty(target.path): INSTALLS += target

unix: INSTALLS += documentation manpage icon desktopfile translationfiles metainfo

DISTFILES += \
    AUTHORS \
    COPYING \
    INSTALL \
    README \
    TODO \
    changelog \
    debian/changelog \
    debian/control \
    debian/copyright \
    debian/forwords.manpages \
    debian/gbp.conf \
    debian/rules \
    debian/source/format \
    debian/upstream/metadata \
    debian/watch \
    docs/MANUAL.txt \
    docs/manual.html \
    docs/pictures/01.png \
    docs/pictures/02.png \
    docs/pictures/03.png \
    docs/pictures/04.png \
    docs/pictures/05.png \
    docs/pictures/06.png \
    docs/pictures/07.png \
    docs/pictures/08.png \
    docs/pictures/09.png \
    docs/pictures/10.png \
    docs/pictures/12.png \
    docs/pictures/13.png \
    docs/pictures/14.png \
    docs/pictures/15.png \
    docs/pictures/16.png \
    docs/pictures/17.png \
    docs/pictures/18.png \
    docs/pictures/19.png \
    docs/pictures/20.png \
    docs/pictures/21.png \
    forwords.1 \
    forwords.desktop \
    forwords.metainfo.xml \
    icons/forwords.png \
    translations/Русский.lp
