---
date: 2026-02-19
section: 1
title: GO-MOD
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

go-mod - module maintenance

# SYNOPSIS

**go mod** *command* \[*arguments*\]

# DESCRIPTION

Go mod provides access to operations on modules.

Note that support for modules is built into all the go commands, not
just 'go mod'. For example, day-to-day adding, removing, upgrading,
and downgrading of dependencies should be done using 'go get'. See
'go help modules' for an overview of module functionality.

# COMMANDS

**download**

:   download modules to local cache

**edit**

:   edit go.mod from tools or scripts

**graph**

:   print module requirement graph

**init**

:   initialize new module in current directory

**tidy**

:   add missing and remove unused modules

**vendor**

:   make vendored copy of dependencies

**verify**

:   verify dependencies have expected content

**why**

:   explain why packages or modules are needed

Use "go help mod \<command\>" for more information about a command.

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
