//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicy

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// AssignmentsClient contains the methods for the PolicyAssignments group.
// Don't use this type directly, use NewAssignmentsClient() instead.
type AssignmentsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAssignmentsClient creates a new instance of AssignmentsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAssignmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AssignmentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AssignmentsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply
// to all resources contained within their scope. For example, when you assign a policy at
// resource group scope, that policy applies to all resources in the group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - scope - The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
//     subscription (format:
//     '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}',
//     or resource (format:
//     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
//   - policyAssignmentName - The name of the policy assignment.
//   - parameters - Parameters for the policy assignment.
//   - options - AssignmentsClientCreateOptions contains the optional parameters for the AssignmentsClient.Create method.
func (client *AssignmentsClient) Create(ctx context.Context, scope string, policyAssignmentName string, parameters Assignment, options *AssignmentsClientCreateOptions) (AssignmentsClientCreateResponse, error) {
	var err error
	const operationName = "AssignmentsClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, scope, policyAssignmentName, parameters, options)
	if err != nil {
		return AssignmentsClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *AssignmentsClient) createCreateRequest(ctx context.Context, scope string, policyAssignmentName string, parameters Assignment, options *AssignmentsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *AssignmentsClient) createHandleResponse(resp *http.Response) (AssignmentsClientCreateResponse, error) {
	result := AssignmentsClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientCreateResponse{}, err
	}
	return result, nil
}

// CreateByID - This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
// apply to all resources contained in that scope. For example, when you assign a policy to a
// resource group that policy applies to all resources in the group. Policy assignment IDs have this format: '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
// Valid
// scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
// (format: '/subscriptions/{subscriptionId}'), resource group (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - policyAssignmentID - The ID of the policy assignment to create. Use the format '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
//   - parameters - Parameters for policy assignment.
//   - options - AssignmentsClientCreateByIDOptions contains the optional parameters for the AssignmentsClient.CreateByID method.
func (client *AssignmentsClient) CreateByID(ctx context.Context, policyAssignmentID string, parameters Assignment, options *AssignmentsClientCreateByIDOptions) (AssignmentsClientCreateByIDResponse, error) {
	var err error
	const operationName = "AssignmentsClient.CreateByID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createByIDCreateRequest(ctx, policyAssignmentID, parameters, options)
	if err != nil {
		return AssignmentsClientCreateByIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientCreateByIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientCreateByIDResponse{}, err
	}
	resp, err := client.createByIDHandleResponse(httpResp)
	return resp, err
}

// createByIDCreateRequest creates the CreateByID request.
func (client *AssignmentsClient) createByIDCreateRequest(ctx context.Context, policyAssignmentID string, parameters Assignment, options *AssignmentsClientCreateByIDOptions) (*policy.Request, error) {
	urlPath := "/{policyAssignmentId}"
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentId}", policyAssignmentID)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createByIDHandleResponse handles the CreateByID response.
func (client *AssignmentsClient) createByIDHandleResponse(resp *http.Response) (AssignmentsClientCreateByIDResponse, error) {
	result := AssignmentsClientCreateByIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientCreateByIDResponse{}, err
	}
	return result, nil
}

// Delete - This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
// assignment is the part of its ID preceding
// '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - scope - The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
//     subscription (format:
//     '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}',
//     or resource (format:
//     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
//   - policyAssignmentName - The name of the policy assignment to delete.
//   - options - AssignmentsClientDeleteOptions contains the optional parameters for the AssignmentsClient.Delete method.
func (client *AssignmentsClient) Delete(ctx context.Context, scope string, policyAssignmentName string, options *AssignmentsClientDeleteOptions) (AssignmentsClientDeleteResponse, error) {
	var err error
	const operationName = "AssignmentsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, scope, policyAssignmentName, options)
	if err != nil {
		return AssignmentsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientDeleteResponse{}, err
	}
	resp, err := client.deleteHandleResponse(httpResp)
	return resp, err
}

// deleteCreateRequest creates the Delete request.
func (client *AssignmentsClient) deleteCreateRequest(ctx context.Context, scope string, policyAssignmentName string, options *AssignmentsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *AssignmentsClient) deleteHandleResponse(resp *http.Response) (AssignmentsClientDeleteResponse, error) {
	result := AssignmentsClientDeleteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientDeleteResponse{}, err
	}
	return result, nil
}

// DeleteByID - This operation deletes the policy with the given ID. Policy assignment IDs have this format: '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
// Valid formats for
// {scope} are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group), '/subscriptions/{subscriptionId}'
// (subscription),
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
// (resource).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - policyAssignmentID - The ID of the policy assignment to delete. Use the format '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
//   - options - AssignmentsClientDeleteByIDOptions contains the optional parameters for the AssignmentsClient.DeleteByID method.
func (client *AssignmentsClient) DeleteByID(ctx context.Context, policyAssignmentID string, options *AssignmentsClientDeleteByIDOptions) (AssignmentsClientDeleteByIDResponse, error) {
	var err error
	const operationName = "AssignmentsClient.DeleteByID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteByIDCreateRequest(ctx, policyAssignmentID, options)
	if err != nil {
		return AssignmentsClientDeleteByIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientDeleteByIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientDeleteByIDResponse{}, err
	}
	resp, err := client.deleteByIDHandleResponse(httpResp)
	return resp, err
}

// deleteByIDCreateRequest creates the DeleteByID request.
func (client *AssignmentsClient) deleteByIDCreateRequest(ctx context.Context, policyAssignmentID string, options *AssignmentsClientDeleteByIDOptions) (*policy.Request, error) {
	urlPath := "/{policyAssignmentId}"
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentId}", policyAssignmentID)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteByIDHandleResponse handles the DeleteByID response.
func (client *AssignmentsClient) deleteByIDHandleResponse(resp *http.Response) (AssignmentsClientDeleteByIDResponse, error) {
	result := AssignmentsClientDeleteByIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientDeleteByIDResponse{}, err
	}
	return result, nil
}

// Get - This operation retrieves a single policy assignment, given its name and the scope it was created at.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - scope - The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
//     subscription (format:
//     '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}',
//     or resource (format:
//     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
//   - policyAssignmentName - The name of the policy assignment to get.
//   - options - AssignmentsClientGetOptions contains the optional parameters for the AssignmentsClient.Get method.
func (client *AssignmentsClient) Get(ctx context.Context, scope string, policyAssignmentName string, options *AssignmentsClientGetOptions) (AssignmentsClientGetResponse, error) {
	var err error
	const operationName = "AssignmentsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, policyAssignmentName, options)
	if err != nil {
		return AssignmentsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AssignmentsClient) getCreateRequest(ctx context.Context, scope string, policyAssignmentName string, options *AssignmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AssignmentsClient) getHandleResponse(resp *http.Response) (AssignmentsClientGetResponse, error) {
	result := AssignmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientGetResponse{}, err
	}
	return result, nil
}

// GetByID - The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format: '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
// Valid
// scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
// (format: '/subscriptions/{subscriptionId}'), resource group (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - policyAssignmentID - The ID of the policy assignment to get. Use the format '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
//   - options - AssignmentsClientGetByIDOptions contains the optional parameters for the AssignmentsClient.GetByID method.
func (client *AssignmentsClient) GetByID(ctx context.Context, policyAssignmentID string, options *AssignmentsClientGetByIDOptions) (AssignmentsClientGetByIDResponse, error) {
	var err error
	const operationName = "AssignmentsClient.GetByID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByIDCreateRequest(ctx, policyAssignmentID, options)
	if err != nil {
		return AssignmentsClientGetByIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientGetByIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientGetByIDResponse{}, err
	}
	resp, err := client.getByIDHandleResponse(httpResp)
	return resp, err
}

// getByIDCreateRequest creates the GetByID request.
func (client *AssignmentsClient) getByIDCreateRequest(ctx context.Context, policyAssignmentID string, options *AssignmentsClientGetByIDOptions) (*policy.Request, error) {
	urlPath := "/{policyAssignmentId}"
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentId}", policyAssignmentID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByIDHandleResponse handles the GetByID response.
func (client *AssignmentsClient) getByIDHandleResponse(resp *http.Response) (AssignmentsClientGetByIDResponse, error) {
	result := AssignmentsClientGetByIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientGetByIDResponse{}, err
	}
	return result, nil
}

// NewListPager - This operation retrieves the list of all policy assignments associated with the given subscription that
// match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()' or
// 'policyDefinitionId eq '{value}”. If $filter is not provided, the unfiltered list includes all policy assignments associated
// with the subscription, including those that apply directly or from
// management groups that contain the given subscription, as well as any applied to objects contained within the subscription.
// If $filter=atScope() is provided, the returned list includes all policy
// assignments that apply to the subscription, which is everything in the unfiltered list except those applied to objects
// contained within the subscription. If $filter=atExactScope() is provided, the
// returned list only includes all policy assignments that at the subscription. If $filter=policyDefinitionId eq '{value}'
// is provided, the returned list includes all policy assignments of the policy
// definition whose id is {value}.
//
// Generated from API version 2022-06-01
//   - options - AssignmentsClientListOptions contains the optional parameters for the AssignmentsClient.NewListPager method.
func (client *AssignmentsClient) NewListPager(options *AssignmentsClientListOptions) *runtime.Pager[AssignmentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AssignmentsClientListResponse]{
		More: func(page AssignmentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AssignmentsClientListResponse) (AssignmentsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AssignmentsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return AssignmentsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *AssignmentsClient) listCreateRequest(ctx context.Context, options *AssignmentsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyAssignments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AssignmentsClient) listHandleResponse(resp *http.Response) (AssignmentsClientListResponse, error) {
	result := AssignmentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentListResult); err != nil {
		return AssignmentsClientListResponse{}, err
	}
	return result, nil
}

// NewListForManagementGroupPager - This operation retrieves the list of all policy assignments applicable to the management
// group that match the given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()' or
// 'policyDefinitionId eq '{value}”. If $filter=atScope() is provided, the returned list includes all policy assignments
// that are assigned to the management group or the management group's ancestors. If
// $filter=atExactScope() is provided, the returned list only includes all policy assignments that at the management group.
// If $filter=policyDefinitionId eq '{value}' is provided, the returned list
// includes all policy assignments of the policy definition whose id is {value} that apply to the management group.
//
// Generated from API version 2022-06-01
//   - managementGroupID - The ID of the management group.
//   - options - AssignmentsClientListForManagementGroupOptions contains the optional parameters for the AssignmentsClient.NewListForManagementGroupPager
//     method.
func (client *AssignmentsClient) NewListForManagementGroupPager(managementGroupID string, options *AssignmentsClientListForManagementGroupOptions) *runtime.Pager[AssignmentsClientListForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AssignmentsClientListForManagementGroupResponse]{
		More: func(page AssignmentsClientListForManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AssignmentsClientListForManagementGroupResponse) (AssignmentsClientListForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AssignmentsClient.NewListForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForManagementGroupCreateRequest(ctx, managementGroupID, options)
			}, nil)
			if err != nil {
				return AssignmentsClientListForManagementGroupResponse{}, err
			}
			return client.listForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForManagementGroupCreateRequest creates the ListForManagementGroup request.
func (client *AssignmentsClient) listForManagementGroupCreateRequest(ctx context.Context, managementGroupID string, options *AssignmentsClientListForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyAssignments"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForManagementGroupHandleResponse handles the ListForManagementGroup response.
func (client *AssignmentsClient) listForManagementGroupHandleResponse(resp *http.Response) (AssignmentsClientListForManagementGroupResponse, error) {
	result := AssignmentsClientListForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentListResult); err != nil {
		return AssignmentsClientListForManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListForResourcePager - This operation retrieves the list of all policy assignments associated with the specified resource
// in the given resource group and subscription that match the optional given $filter. Valid values for
// $filter are: 'atScope()', 'atExactScope()' or 'policyDefinitionId eq '{value}”. If $filter is not provided, the unfiltered
// list includes all policy assignments associated with the resource, including
// those that apply directly or from all containing scopes, as well as any applied to resources contained within the resource.
// If $filter=atScope() is provided, the returned list includes all policy
// assignments that apply to the resource, which is everything in the unfiltered list except those applied to resources contained
// within the resource. If $filter=atExactScope() is provided, the returned
// list only includes all policy assignments that at the resource level. If $filter=policyDefinitionId eq '{value}' is provided,
// the returned list includes all policy assignments of the policy definition
// whose id is {value} that apply to the resource. Three parameters plus the resource name are used to identify a specific
// resource. If the resource is not part of a parent resource (the more common
// case), the parent resource path should not be provided (or provided as ”). For example a web app could be specified as
// ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} == ”,
// {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then all parameters
// should be provided. For example a virtual machine DNS name could be
// specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
// {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
// convenient alternative to providing the namespace and type name separately is to provide both in the {resourceType} parameter,
// format: ({resourceProviderNamespace} == ”, {parentResourcePath} == ”,
// {resourceType} == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
//
// Generated from API version 2022-06-01
//   - resourceGroupName - The name of the resource group containing the resource.
//   - resourceProviderNamespace - The namespace of the resource provider. For example, the namespace of a virtual machine is
//     Microsoft.Compute (from Microsoft.Compute/virtualMachines)
//   - parentResourcePath - The parent resource path. Use empty string if there is none.
//   - resourceType - The resource type name. For example the type name of a web app is 'sites' (from Microsoft.Web/sites).
//   - resourceName - The name of the resource.
//   - options - AssignmentsClientListForResourceOptions contains the optional parameters for the AssignmentsClient.NewListForResourcePager
//     method.
func (client *AssignmentsClient) NewListForResourcePager(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *AssignmentsClientListForResourceOptions) *runtime.Pager[AssignmentsClientListForResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[AssignmentsClientListForResourceResponse]{
		More: func(page AssignmentsClientListForResourceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AssignmentsClientListForResourceResponse) (AssignmentsClientListForResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AssignmentsClient.NewListForResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForResourceCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, options)
			}, nil)
			if err != nil {
				return AssignmentsClientListForResourceResponse{}, err
			}
			return client.listForResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForResourceCreateRequest creates the ListForResource request.
func (client *AssignmentsClient) listForResourceCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *AssignmentsClientListForResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/policyAssignments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForResourceHandleResponse handles the ListForResource response.
func (client *AssignmentsClient) listForResourceHandleResponse(resp *http.Response) (AssignmentsClientListForResourceResponse, error) {
	result := AssignmentsClientListForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentListResult); err != nil {
		return AssignmentsClientListForResourceResponse{}, err
	}
	return result, nil
}

// NewListForResourceGroupPager - This operation retrieves the list of all policy assignments associated with the given resource
// group in the given subscription that match the optional given $filter. Valid values for $filter are:
// 'atScope()', 'atExactScope()' or 'policyDefinitionId eq '{value}”. If $filter is not provided, the unfiltered list includes
// all policy assignments associated with the resource group, including those
// that apply directly or apply from containing scopes, as well as any applied to resources contained within the resource
// group. If $filter=atScope() is provided, the returned list includes all policy
// assignments that apply to the resource group, which is everything in the unfiltered list except those applied to resources
// contained within the resource group. If $filter=atExactScope() is provided,
// the returned list only includes all policy assignments that at the resource group. If $filter=policyDefinitionId eq '{value}'
// is provided, the returned list includes all policy assignments of the
// policy definition whose id is {value} that apply to the resource group.
//
// Generated from API version 2022-06-01
//   - resourceGroupName - The name of the resource group that contains policy assignments.
//   - options - AssignmentsClientListForResourceGroupOptions contains the optional parameters for the AssignmentsClient.NewListForResourceGroupPager
//     method.
func (client *AssignmentsClient) NewListForResourceGroupPager(resourceGroupName string, options *AssignmentsClientListForResourceGroupOptions) *runtime.Pager[AssignmentsClientListForResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AssignmentsClientListForResourceGroupResponse]{
		More: func(page AssignmentsClientListForResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AssignmentsClientListForResourceGroupResponse) (AssignmentsClientListForResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AssignmentsClient.NewListForResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return AssignmentsClientListForResourceGroupResponse{}, err
			}
			return client.listForResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForResourceGroupCreateRequest creates the ListForResourceGroup request.
func (client *AssignmentsClient) listForResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *AssignmentsClientListForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/policyAssignments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForResourceGroupHandleResponse handles the ListForResourceGroup response.
func (client *AssignmentsClient) listForResourceGroupHandleResponse(resp *http.Response) (AssignmentsClientListForResourceGroupResponse, error) {
	result := AssignmentsClientListForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentListResult); err != nil {
		return AssignmentsClientListForResourceGroupResponse{}, err
	}
	return result, nil
}

// Update - This operation updates a policy assignment with the given scope and name. Policy assignments apply to all resources
// contained within their scope. For example, when you assign a policy at resource
// group scope, that policy applies to all resources in the group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - scope - The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
//     subscription (format:
//     '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}',
//     or resource (format:
//     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
//   - policyAssignmentName - The name of the policy assignment.
//   - parameters - Parameters for policy assignment patch request.
//   - options - AssignmentsClientUpdateOptions contains the optional parameters for the AssignmentsClient.Update method.
func (client *AssignmentsClient) Update(ctx context.Context, scope string, policyAssignmentName string, parameters AssignmentUpdate, options *AssignmentsClientUpdateOptions) (AssignmentsClientUpdateResponse, error) {
	var err error
	const operationName = "AssignmentsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, scope, policyAssignmentName, parameters, options)
	if err != nil {
		return AssignmentsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *AssignmentsClient) updateCreateRequest(ctx context.Context, scope string, policyAssignmentName string, parameters AssignmentUpdate, options *AssignmentsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *AssignmentsClient) updateHandleResponse(resp *http.Response) (AssignmentsClientUpdateResponse, error) {
	result := AssignmentsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateByID - This operation updates the policy assignment with the given ID. Policy assignments made on a scope apply to
// all resources contained in that scope. For example, when you assign a policy to a resource
// group that policy applies to all resources in the group. Policy assignment IDs have this format: '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
// Valid scopes are:
// management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
// '/subscriptions/{subscriptionId}'), resource group (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-06-01
//   - policyAssignmentID - The ID of the policy assignment to update. Use the format '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
//   - parameters - Parameters for policy assignment patch request.
//   - options - AssignmentsClientUpdateByIDOptions contains the optional parameters for the AssignmentsClient.UpdateByID method.
func (client *AssignmentsClient) UpdateByID(ctx context.Context, policyAssignmentID string, parameters AssignmentUpdate, options *AssignmentsClientUpdateByIDOptions) (AssignmentsClientUpdateByIDResponse, error) {
	var err error
	const operationName = "AssignmentsClient.UpdateByID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateByIDCreateRequest(ctx, policyAssignmentID, parameters, options)
	if err != nil {
		return AssignmentsClientUpdateByIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AssignmentsClientUpdateByIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AssignmentsClientUpdateByIDResponse{}, err
	}
	resp, err := client.updateByIDHandleResponse(httpResp)
	return resp, err
}

// updateByIDCreateRequest creates the UpdateByID request.
func (client *AssignmentsClient) updateByIDCreateRequest(ctx context.Context, policyAssignmentID string, parameters AssignmentUpdate, options *AssignmentsClientUpdateByIDOptions) (*policy.Request, error) {
	urlPath := "/{policyAssignmentId}"
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentId}", policyAssignmentID)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateByIDHandleResponse handles the UpdateByID response.
func (client *AssignmentsClient) updateByIDHandleResponse(resp *http.Response) (AssignmentsClientUpdateByIDResponse, error) {
	result := AssignmentsClientUpdateByIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Assignment); err != nil {
		return AssignmentsClientUpdateByIDResponse{}, err
	}
	return result, nil
}
