// Copyright 2009-2021 Intel Corporation
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include "ze_wrapper.h"

/* except for following enums EXP and EXT API is binary compatible */

enum ze_result_helper_t {
  ZE_RESULT_HELPER_EXP_RTAS_BUILD_RETRY = ZE_RESULT_EXP_RTAS_BUILD_RETRY,
  ZE_RESULT_HELPER_EXP_RTAS_BUILD_DEFERRED = ZE_RESULT_EXP_RTAS_BUILD_DEFERRED,

  ZE_RESULT_HELPER_EXT_RTAS_BUILD_RETRY = ZE_RESULT_EXT_RTAS_BUILD_RETRY,
  ZE_RESULT_HELPER_EXT_RTAS_BUILD_DEFERRED = ZE_RESULT_EXT_RTAS_BUILD_DEFERRED,
};

enum ze_structure_type_helper_t {
  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXP_DESC = ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXP_DESC,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_BUILD_OP_EXP_DESC = ZE_STRUCTURE_TYPE_RTAS_BUILDER_BUILD_OP_EXP_DESC,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXP_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXP_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_PARALLEL_OPERATION_EXP_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_PARALLEL_OPERATION_EXP_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_DEVICE_EXP_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_DEVICE_EXP_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_GEOMETRY_AABBS_EXP_CB_PARAMS = ZE_STRUCTURE_TYPE_RTAS_GEOMETRY_AABBS_EXP_CB_PARAMS,

  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXT_DESC = ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXT_DESC,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_BUILD_OP_EXT_DESC = ZE_STRUCTURE_TYPE_RTAS_BUILDER_BUILD_OP_EXT_DESC,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXT_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXT_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_PARALLEL_OPERATION_EXT_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_PARALLEL_OPERATION_EXT_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_DEVICE_EXT_PROPERTIES = ZE_STRUCTURE_TYPE_RTAS_DEVICE_EXT_PROPERTIES,
  ZE_STRUCTURE_TYPE_HELPER_RTAS_GEOMETRY_AABBS_EXT_CB_PARAMS = ZE_STRUCTURE_TYPE_RTAS_GEOMETRY_AABBS_EXT_CB_PARAMS,
};

#define ZE_RESULT_EXP_RTAS_BUILD_RETRY    (ze_result_t)((aty == EXP_API) ? ZE_RESULT_HELPER_EXP_RTAS_BUILD_RETRY    : ZE_RESULT_HELPER_EXT_RTAS_BUILD_RETRY)
#define ZE_RESULT_EXP_RTAS_BUILD_DEFERRED (ze_result_t)((aty == EXP_API) ? ZE_RESULT_HELPER_EXP_RTAS_BUILD_DEFERRED : ZE_RESULT_HELPER_EXT_RTAS_BUILD_DEFERRED)

#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXP_DESC                  (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXP_DESC                  : ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXT_DESC)
#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_BUILD_OP_EXP_DESC         (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_BUILD_OP_EXP_DESC         : ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_BUILD_OP_EXT_DESC)
#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXP_PROPERTIES            (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXP_PROPERTIES            : ZE_STRUCTURE_TYPE_HELPER_RTAS_BUILDER_EXT_PROPERTIES)
#define ZE_STRUCTURE_TYPE_RTAS_PARALLEL_OPERATION_EXP_PROPERTIES (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_PARALLEL_OPERATION_EXP_PROPERTIES : ZE_STRUCTURE_TYPE_HELPER_RTAS_PARALLEL_OPERATION_EXT_PROPERTIES)
#define ZE_STRUCTURE_TYPE_RTAS_DEVICE_EXP_PROPERTIES             (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_DEVICE_EXP_PROPERTIES             : ZE_STRUCTURE_TYPE_HELPER_RTAS_DEVICE_EXT_PROPERTIES)
#define ZE_STRUCTURE_TYPE_RTAS_GEOMETRY_AABBS_EXP_CB_PARAMS      (ze_structure_type_t)((aty == EXP_API) ? ZE_STRUCTURE_TYPE_HELPER_RTAS_GEOMETRY_AABBS_EXP_CB_PARAMS      : ZE_STRUCTURE_TYPE_HELPER_RTAS_GEOMETRY_AABBS_EXT_CB_PARAMS)

#define ZE_RESULT_EXT_RTAS_BUILD_RETRY
#define ZE_RESULT_EXT_RTAS_BUILD_DEFERRED

#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXT_DESC
#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_BUILD_OP_EXT_DESC
#define ZE_STRUCTURE_TYPE_RTAS_BUILDER_EXT_PROPERTIES
#define ZE_STRUCTURE_TYPE_RTAS_PARALLEL_OPERATION_EXT_PROPERTIES
#define ZE_STRUCTURE_TYPE_RTAS_DEVICE_EXT_PROPERTIES
#define ZE_STRUCTURE_TYPE_RTAS_GEOMETRY_AABBS_EXT_CB_PARAMS
