; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s

declare float @llvm.ceil.f32(float)
define float @ceil_f32(float %a) {
; CHECK-LABEL: ceil_f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $sp, $sp, -24
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset 31, -4
; CHECK-NEXT:    jal ceilf
; CHECK-NEXT:    nop
; CHECK-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; CHECK-NEXT:    addiu $sp, $sp, 24
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %0 = call float @llvm.ceil.f32(float %a)
  ret float %0
}

declare double @llvm.ceil.f64(double)
define double @ceil_f64(double %a) {
; CHECK-LABEL: ceil_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $sp, $sp, -24
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset 31, -4
; CHECK-NEXT:    jal ceil
; CHECK-NEXT:    nop
; CHECK-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; CHECK-NEXT:    addiu $sp, $sp, 24
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %0 = call double @llvm.ceil.f64(double %a)
  ret double %0
}

declare float @llvm.floor.f32(float)
define float @floor_f32(float %a) {
; CHECK-LABEL: floor_f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $sp, $sp, -24
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset 31, -4
; CHECK-NEXT:    jal floorf
; CHECK-NEXT:    nop
; CHECK-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; CHECK-NEXT:    addiu $sp, $sp, 24
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %0 = call float @llvm.floor.f32(float %a)
  ret float %0
}

declare double @llvm.floor.f64(double)
define double @floor_f64(double %a) {
; CHECK-LABEL: floor_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addiu $sp, $sp, -24
; CHECK-NEXT:    .cfi_def_cfa_offset 24
; CHECK-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset 31, -4
; CHECK-NEXT:    jal floor
; CHECK-NEXT:    nop
; CHECK-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; CHECK-NEXT:    addiu $sp, $sp, 24
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %0 = call double @llvm.floor.f64(double %a)
  ret double %0
}
