// RUN: mlir-translate -mlir-to-llvmir %s | FileCheck %s

module attributes {dlti.dl_spec = #dlti.dl_spec<#dlti.dl_entry<"dlti.alloca_memory_space", 5 : ui32>>, llvm.target_triple = "amdgcn-amd-amdhsa", omp.is_target_device = true} {
  llvm.func @_QQmain() attributes {bindc_name = "main"} {
    %0 = llvm.mlir.addressof @_QFEsp : !llvm.ptr
    %1 = omp.map.info var_ptr(%0 : !llvm.ptr, !llvm.array<10 x i32>) map_clauses(tofrom) capture(ByRef) -> !llvm.ptr {name = "sp"}
    omp.target map_entries(%1 -> %arg0 : !llvm.ptr) {
      %2 = llvm.mlir.constant(20 : i32) : i32
      %3 = llvm.mlir.constant(0 : i64) : i64
      %4 = llvm.getelementptr %arg0[0, %3] : (!llvm.ptr, i64) -> !llvm.ptr, !llvm.array<10 x i32>
      llvm.store %2, %4 : i32, !llvm.ptr
      %5 = llvm.mlir.constant(10 : i32) : i32
      %6 = llvm.mlir.constant(4 : i64) : i64
      %7 = llvm.getelementptr %arg0[0, %6] : (!llvm.ptr, i64) -> !llvm.ptr, !llvm.array<10 x i32>
      llvm.store %5, %7 : i32, !llvm.ptr
      omp.terminator
    }
    llvm.return
  }
  llvm.mlir.global internal @_QFEsp(dense<0> : tensor<10xi32>) {addr_space = 0 : i32} : !llvm.array<10 x i32>
  llvm.mlir.global external constant @_QQEnvironmentDefaults() {addr_space = 0 : i32} : !llvm.ptr {
    %0 = llvm.mlir.zero : !llvm.ptr
    llvm.return %0 : !llvm.ptr
  }
}


// CHECK: define {{.*}} void @__omp_offloading_{{.*}}_{{.*}}__QQmain_{{.*}}(ptr %{{.*}}, ptr %[[ARG1:.*]]) #{{[0-9]+}} {

// CHECK: %[[ARG1_ALLOCA:.*]] = alloca ptr, align 8, addrspace(5)
// CHECK: %[[ARG1_ASCAST:.*]] = addrspacecast ptr addrspace(5) %[[ARG1_ALLOCA]] to ptr
// CHECK: store ptr %[[ARG1]], ptr %[[ARG1_ASCAST]], align 8
// CHECK: %[[LOAD_ARG1_ALLOCA:.*]] = load ptr, ptr %[[ARG1_ASCAST]], align 8
// CHECK: store i32 20, ptr %[[LOAD_ARG1_ALLOCA]], align 4
// CHECK: %[[GEP_ARG1_ALLOCA:.*]] = getelementptr inbounds nuw i8, ptr %[[LOAD_ARG1_ALLOCA]], i64 16
// CHECK: store i32 10, ptr %[[GEP_ARG1_ALLOCA]], align 4

