<?php
	plugin_header();
	
	$m      =   (strpos($PAGE, '_mono') > 0) ? 'm' : (
				(strpos($PAGE, '_stereo') > 0) ? 's' : (
				(strpos($PAGE, '_lr') > 0) ? 'lr' : (
				(strpos($PAGE, '_ms') > 0) ? 'ms' : '?'
				)));
?>

<p>
    <?php if ($m == 'm') { ?>
    	This plugin performs split of mono input signal into separate frequency bands passed to individual mono output channels.
    	Additionally it provides output monitoring channel to control individual channels or result of summing signals passed
    	to individual mono output channels.
    <?php } elseif ($m == 's') { ?>
		This plugin performs split of stereo input signal into separate frequency bands passed to individual stereo output channels.
		Additionally it provides output monitoring channel to control individual channels or result of summing signals
		passed to individual stereo output channels.
	<?php } elseif ($m == 'lr') { ?>
		This plugin performs split of individual channels of the stereo input stereo signal into separate frequency bands passed to
		individual stereo output channels. Additionally it provides output monitoring channel to control individual channels or
		result of summing signals passed to individual stereo output channels.
	<?php } else { ?>
		This plugin converts the stereo input signal into Mid/Side signal and performs split of the Mid/Side signal into separate frequency
		bands passed to individual Mid/Side output channels. Additionally it provides output monitoring channel to control the result of summing
		signals passed to individual Mid/Side output channels. The output Mid/Side signal also can be inspected by pressing <b>MS Listen</b> button.
	<?php } ?>
	The additional benefit of using monitoring channel is that the plugin may be placed in the middle of track/bus without creating an additional
	bus for processing.
</p>
<p>
    By default plugin enables 4 frequency bands but overall number of used frequency bands may vary from 1 to 8.
    Each range of the frequency band can be adjusted by specifying the slope of the corresponding Low-pass and High-pass filters.
    The frequency graph allows to view characteristics of filters for each frequency band and the result of summing the frequency response
    for all filters. For better audio engineering the plugin additionally provides FFT analysis of input and output signal.
</p>
<p>
	Additional <b>Linear Phase</b> mode allows to split audio signal into multiple frequency bands with linear phase shift.
	This introduces additional latency but gives several benefits:
</p>
<ul>
	<li>Unlike classic crossovers which use IIR (Infinite Impulse Response) filters to split signal into multiple bands and shift the phase
	of the audio signal at band split points, the <b>Linear Phase</b> allows to use FIR (Finite Impulse Response) filters which are deprived of this.
	<li>Unlike most IIR filters which are designed using bilinear transform, linear phase filters allow simulate their transfer function
	to look like the transfer function of analog filters, without deforming it's magnitude envelope near the nyquist frequency.</li>
	<li>Unlike design of classic Linkwitz-Riley filters, the design of IIR filters provides shorter transition zone of the filter.</li>
</ul>
<p>
	Note that <b>Phase</b> and <b>Delay</b> band parameters do not affect the estimated frequency graph which is computed
	for non-inverted band phase and zero delay value. For another settings, the actual frequency response can be obtained from
	the FFT analysis of the output signal.
</p>

<p><b>Controls:</b></p>
<ul>
	<li>
		<b>Bypass</b> - bypass switch, passes the signal from the input of plugin to the monitoring output without any changes.
	</li>
	<li><b>FFT In</b> - enables FFT analysis of the input signal for the corresponding input channel.
	<li><b>FFT Out</b> - enables FFT analysis of the input signal for the corresponding input channel.
	<?php if ($m == 'lr') { ?>
		<li><b>L/R Link</b> - enables linking between Left and Right channel controls so change of one forces the sibling to become the same value.</li>
	<?php } elseif ($m == 'ms') { ?>
		<li><b>M/S Link</b> - enables linking between Mid and Side channel controls so change of one forces the sibling to become the same value.</li>
	<?php } ?>
	<li><b>S/M Apply</b> - applies effect of Solo/Mute buttons to corresponding frequency band's outputs.
	<li><b>Filters</b> - shows filter characteristics of each band for the corresponding channel.
	<li><b>Curve</b> - shows the output signal curve of each band for the corresponding channel.
	<?php if ($m == 'ms') { ?>
	<li><b>MS Listen</b> - passes Mid/Side signal to the monitoring channel instead of stereo signal.
	<?php } ?>
	<li><b>Zoom</b> - zoom fader, allows to adjust zoom on the frequency chart.</li>
</ul>
<p><b>'Processor' section:</b></p>
<ul>
	<li><b>Slope</b> - allows to select the slope of filters attached to corresponding frequency band or disable the frequency band.</li>
	<li><b>Range</b> - allows to adjust the frequency range for each band.</li>
	<li><b>Gain</b> - adjusts gain to the corresponding frequency band.</li>
	<li><b>Solo</b> - enables soloing of the corresponding frequency band for the monitoring channel.</li>
	<li><b>Mute</b> - mutes the corresponding frequency band for the monitoring channel.</li>
	<li><b>Phase</b> - inverts phase for the the corresponding frequency band.</li>
	<li><b>Delay</b> - adds specified delay for the corresponding frequency band.</li>
	<li><b>Hue</b> - adjusts hue of the frequency band in the UI.</li>
</ul>
<p><b>'Signal' section:</b></p>
<ul>
	<li><b>Input</b> - the amount of gain applied to the input signal before processing.</li>
	<li><b>Output</b> - the amount of gain applied to the output signal before processing.</li>
</ul>
<p><b>'Analysis' section:</b></p>
<ul>
	<li><b>Reactivity</b> - the reactivity (smoothness) of the spectral analysis.</li>
	<li><b>Shift</b> - allows to adjust the overall gain of the analysis.</li>
</ul>

