/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class Translate
extends Function {
    public String getName() {
        return "translate";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        boolean bl;
        int n = this.checkArgumentCount(3, 3);
        this.argument[0] = this.argument[0].simplify();
        this.argument[1] = this.argument[1].simplify();
        this.argument[2] = this.argument[2].simplify();
        boolean bl2 = bl = this.argument[0] instanceof Value && this.argument[1] instanceof Value && this.argument[2] instanceof Value;
        if (bl) {
            return this.evaluate(null);
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        String string2 = this.argument[1].evaluateAsString(context);
        String string3 = this.argument[2].evaluateAsString(context);
        return Translate.translate(string, string2, string3);
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDependencies() {
        return this.argument[0].getDependencies() | this.argument[1].getDependencies() | this.argument[2].getDependencies();
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Translate translate = new Translate();
        translate.addArgument(this.argument[0].reduce(n, context));
        translate.addArgument(this.argument[1].reduce(n, context));
        translate.addArgument(this.argument[2].reduce(n, context));
        translate.setStaticContext(this.getStaticContext());
        return translate.simplify();
    }

    private static String translate(String string, String string2, String string3) {
        int n = StringValue.getLength(string);
        int n2 = StringValue.getLength(string2);
        int n3 = StringValue.getLength(string3);
        if (string.length() != n || string2.length() != n2 || string3.length() != n3) {
            return Translate.slowTranslate(string, string2, string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string3.length();
        int n5 = 0;
        while (n5 < string.length()) {
            char c = string.charAt(n5);
            int n6 = string2.indexOf(c);
            if (n6 < n4) {
                stringBuffer.append(n6 < 0 ? c : string3.charAt(n6));
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    private static String slowTranslate(String string, String string2, String string3) {
        int[] nArray = StringValue.expand(string);
        int[] nArray2 = StringValue.expand(string2);
        int[] nArray3 = StringValue.expand(string3);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            int n3 = -1;
            int n4 = 0;
            while (n4 < nArray2.length) {
                if (nArray2[n4] == n2) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            int n5 = -1;
            if (n3 < 0) {
                n5 = nArray[n];
            } else if (n3 < nArray3.length) {
                n5 = nArray3[n3];
            }
            if (n5 >= 0) {
                if (n5 < 65536) {
                    stringBuffer.append((char)n5);
                } else {
                    stringBuffer.append((char)((n5 -= 65536) / 1024 + 55296));
                    stringBuffer.append((char)(n5 % 1024 + 56320));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

