#!/bin/env python3

import re
import sys
import pathlib
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("infile", type=pathlib.Path)
parser.add_argument("outfile", type=pathlib.Path, nargs="?")

args = parser.parse_args()

infile = args.infile
outfile = args.outfile if args.outfile is not None else infile

data = infile.read_text()
new_data = re.sub(
    r'<div class=\"highlight\"><pre>\s+mkdir -p failed(.*\s){2}</pre></div>',
    '',
    data,
    count=1,
    flags=re.M,
)
outfile.write_text(new_data)
