/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QObject>
#include <QMainWindow>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_MzLabWnd.h"
#include "AbstractMainTaskWindow.hpp"


namespace MsXpS
{
namespace MassXpert
{


class MzLabInputOligomerTableViewDlg;
class ProgramWindow;
class OligomerPair;

class MzLabWnd : public AbstractMainTaskWindow
{
  Q_OBJECT

  public:
  MzLabWnd(ProgramWindow *parent,
           const QString &polChemDefFilePath,
           const QString &application_name,
           const QString &description);

  ~MzLabWnd();

  bool m_forciblyClose = false;


  libXpertMassCore::PolChemDefCstSPtr polChemDefCstSPtr();
  libXpertMassCore::PolChemDefSPtr pol_chem_def_sp();

  const libXpertMassCore::Ionizer &ionizer() const;

  MzLabInputOligomerTableViewDlg *findDlg(const QString &);
  MzLabInputOligomerTableViewDlg *newInputList(QString,
                                               libXpertMassCore::Enums::MassType);

  bool inputListDlg(MzLabInputOligomerTableViewDlg **);
  bool inputListsDlg(MzLabInputOligomerTableViewDlg **,
                     MzLabInputOligomerTableViewDlg **);
  MzLabInputOligomerTableViewDlg *inputListDlg();

  bool inPlaceCalculation();

  bool maybeSave();

  public slots:
  MzLabInputOligomerTableViewDlg *newInputList();

  protected:
  Ui::MzLabWnd m_ui;

  QList<double> m_listM1;
  QList<double> m_listM2;

  QStringList m_modifList;

  libXpertMassCore::PolChemDefSPtr msp_polChemDef;

  QList<MzLabInputOligomerTableViewDlg *> m_dlgList;
  ProgramWindow *mp_mainWindow;

  libXpertMassCore::Ionizer m_ionizer;

  void destroyDlg(const QString &);

  double calculateTolerance(double);

  protected slots:
  void massBasedActionsPushButton();
  void formulaBasedActionsPushButton();
  void matchBasedActionsPushButton();

  void deleteInputListItem();
  void inputListWidgetItemClicked(QListWidgetItem *);

  void updateWindowTitle();

  void ionizationChargeChanged(int);
  void ionizationLevelChanged(int);
  void ionizationFormulaChanged(const QString &);

  void readSettings();
  void writeSettings();

  bool initialize();

  void closeEvent(QCloseEvent *event);
};


} // namespace MassXpert
} // namespace MsXpS
