---
short-description: Localization with GNU Gettext
...

# Localisation

Localising your application with GNU gettext takes a little effort but
is quite straightforward. We'll create a `po` subdirectory at your
project root directory for all the localisation info.

## Generating .pot and .po files

In your main meson.build file include the `po` subdirectory in the build process.

    subdir('po')

In this `po` subdirectory we need:
- `LINGUAS`: Space separated list of languages
- `POTFILES`: List of source files to scan for translatable strings.
- `meson.build`: Localization specific Meson file

### LINGUAS

File with space separated list of languages. A sample LINGUAS might look like this.

    aa ab ae af

### POTFILES

File that lists all the source files that gettext should scan in order
to find strings to translate. The syntax of the file is one line per
source file and the line must contain the relative path from source
root. A sample POTFILES might look like this.

    src/file1.c
    src/file2.c
    src/subdir/file3.c
    include/mything/somefile.h

### meson.build

Localization specific Meson file. It imports and uses the `i18n`
module. If not defined before it needs to define the `GETTEXT_PACKAGE`
global.

```meson
i18n = import('i18n')
# define GETTEXT_PACKAGE
add_project_arguments('-DGETTEXT_PACKAGE="intltest"', language:'c')
i18n.gettext(meson.project_name())
```

The first command imports the `i18n` module that provides gettext
features. The fourth line does the actual invocation. The first
argument is the gettext package name. This causes two things to
happen. The first is that Meson will generate binary mo files and put
them to their proper locations when doing an install. The second is
that it creates a build rule to regenerate the main pot file. If you
are using the Ninja backend, this is how you would invoke the rebuild.

### generate .pot file

Then we need to generate the main pot file. The potfile can have any
name but is usually the name of the gettext package. Let's say the
project is called *intltest*. In this case the corresponding pot file
would be called `intltest.pot`.

Run the following command from your build folder to generate the pot
file. It is recommended to inspect it manually afterwards and fill in
e.g. proper copyright and contact information.

```console
$ meson compile intltest-pot
```

### generate .po files

For each language listed in the array above we need a corresponding
`.po` file. Those can be generated by running the following command
from your build folder.

```console
$ meson compile intltest-update-po
```
