# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.loganalytics.aio import LogAnalyticsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestLogAnalyticsManagementSummaryLogsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(LogAnalyticsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_list_by_workspace(self, resource_group):
        response = self.client.summary_logs.list_by_workspace(
            resource_group_name=resource_group.name,
            workspace_name="str",
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.summary_logs.begin_create_or_update(
                resource_group_name=resource_group.name,
                workspace_name="str",
                summary_logs_name="str",
                parameters={
                    "description": "str",
                    "displayName": "str",
                    "id": "str",
                    "isActive": bool,
                    "name": "str",
                    "provisioningState": "str",
                    "ruleDefinition": {
                        "binDelay": 0,
                        "binSize": 0,
                        "binStartTime": "2020-02-20 00:00:00",
                        "destinationTable": "str",
                        "query": "str",
                        "timeSelector": "str",
                    },
                    "ruleType": "str",
                    "statusCode": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_get(self, resource_group):
        response = await self.client.summary_logs.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            summary_logs_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_begin_delete(self, resource_group):
        response = await (
            await self.client.summary_logs.begin_delete(
                resource_group_name=resource_group.name,
                workspace_name="str",
                summary_logs_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_begin_start(self, resource_group):
        response = await (
            await self.client.summary_logs.begin_start(
                resource_group_name=resource_group.name,
                workspace_name="str",
                summary_logs_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_stop(self, resource_group):
        response = await self.client.summary_logs.stop(
            resource_group_name=resource_group.name,
            workspace_name="str",
            summary_logs_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_summary_logs_begin_retry_bin(self, resource_group):
        response = await (
            await self.client.summary_logs.begin_retry_bin(
                resource_group_name=resource_group.name,
                workspace_name="str",
                summary_logs_name="str",
                parameters={"properties": {"retryBinStartTime": "2020-02-20 00:00:00"}},
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
