% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExhaustiveIndex-class.R
\docType{class}
\name{ExhaustiveIndex}
\alias{ExhaustiveIndex}
\alias{ExhaustiveIndex-class}
\alias{bnorder,ExhaustiveIndex-method}
\title{The ExhaustiveIndex class}
\usage{
ExhaustiveIndex(data, NAMES = NULL, distance = "Euclidean")
}
\arguments{
\item{data}{A numeric matrix with data points in columns and dimensions in rows.}

\item{NAMES}{A character vector of sample names or \code{NULL}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An ExhaustiveIndex object.
}
\description{
A class to hold the data for exact nearest neighbor identification.
}
\details{
Users should never need to call the constructor explicitly, but should generate 
instances of ExhaustiveIndex classes with \code{\link{buildExhaustive}}.

Users can get values from an ExhaustiveIndex object with the usual \code{[[} syntax.
All parameters listed in the constructor can be extracted in this manner.
}
\examples{
example(buildExhaustive)
out[['distance']]
bndistance(out)

}
\seealso{
\code{\link{buildExhaustive}}, for the index construction.

\linkS4class{BiocNeighborIndex}, for the parent class and its available methods.
}
