% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-CellDataSet.R
\docType{methods}
\name{CellDataSet-methods}
\alias{CellDataSet-methods}
\alias{sizeFactors,CellDataSet-method}
\alias{CellDataSet,ANY,ANY-method}
\alias{sizeFactors<-,CellDataSet,numeric-method}
\alias{CellDataSet,ANY,ANY-method}
\alias{estimateSizeFactors,CellDataSet-method}
\alias{CellDataSet,ANY,ANY-method}
\alias{estimateDispersions,CellDataSet-method}
\alias{CellDataSet,ANY,ANY-method}
\title{Methods for the CellDataSet class}
\usage{
\S4method{sizeFactors}{CellDataSet}(object)

\S4method{sizeFactors}{CellDataSet,numeric}(object) <- value

\S4method{estimateSizeFactors}{CellDataSet}(object, locfunc = median, ...)

\S4method{estimateDispersions}{CellDataSet}(object, modelFormulaStr = "~ 1",
  relative_expr = TRUE, min_cells_detected = 1, remove_outliers = TRUE,
  cores = 1, ...)
}
\arguments{
\item{object}{The CellDataSet object}

\item{value}{A vector of size factors, with length equal to the cells in object}

\item{locfunc}{A function applied to the geometric-mean-scaled expression values to derive the size factor.}

\item{...}{Additional arguments to be passed to estimateSizeFactorsForMatrix}

\item{modelFormulaStr}{A model formula, passed as a string, specifying how to group the cells prior to estimated dispersion. 
The default groups all cells together.}

\item{relative_expr}{Whether to transform expression into relative values}

\item{min_cells_detected}{Only include genes detected above lowerDetectionLimit in at least this many cells in the dispersion calculation}

\item{remove_outliers}{Whether to remove outliers (using Cook's distance) when estimating dispersions}

\item{cores}{The number of cores to use for computing dispersions}
}
\description{
Methods for the CellDataSet class
}
