% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_aggregate.R
\name{aw_aggregate}
\alias{aw_aggregate}
\title{Aggregate Estimates Based on Target ID}
\usage{
aw_aggregate(.data, target, tid, interVar, newVar)
}
\arguments{
\item{.data}{A given intersected dataset}

\item{target}{A \code{sf} object that data should be interpolated to}

\item{tid}{A unique identification number within \code{target}}

\item{interVar}{A variable containing an interpolated value created by \code{aw_calculate}}

\item{newVar}{Optional; a new field name to store the interpolated value in. If not specified,
the \code{interVar} argument will be used as the new field name.}
}
\value{
A \code{sf} object with the interpolated value added to it.
}
\description{
\code{aw_aggregate} sums the new estimates produced by \link{aw_calculate}
    based on the target id. These are then joined with the target data. This is
    the fourth step in the interpolation process after \link{aw_weight}.
}
\examples{
library(dplyr)

race <- select(ar_stl_race, GEOID, TOTAL_E)
wards <- select(ar_stl_wards, WARD)

wards \%>\%
    aw_intersect(source = race, areaVar = "area") \%>\%
    aw_total(source = race, id = GEOID, areaVar = "area", totalVar = "totalArea",
             weight = "sum", type = "extensive") \%>\%
    aw_weight(areaVar = "area", totalVar = "totalArea", areaWeight = "areaWeight") \%>\%
    aw_calculate(value = "TOTAL_E", areaWeight = "areaWeight") -> intersect

aw_aggregate(intersect, target = wards, tid = WARD, interVar = TOTAL_E)

}
