% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcovHC.glmmTMB}
\alias{vcovHC.glmmTMB}
\alias{vcovHC}
\title{Cluster Robust Variance-Covariance Matrix Estimator}
\usage{
\method{vcovHC}{glmmTMB}(x, type = "HC0", sandwich = TRUE, ...)
}
\arguments{
\item{x}{a \code{glmmTMB} object fitted with ML (REML is not supported).}

\item{type}{only "HC0" is currently supported for \code{glmmTMB} models.}

\item{sandwich}{logical; if \code{TRUE}, return the sandwich estimator,
otherwise only the meat matrix is returned.}

\item{...}{additional arguments passed to \code{\link{meatHC}} and
\code{\link{sandwich}}, in particular the \code{full} and \code{cluster} arguments are useful.}
}
\value{
A square matrix representing the cluster-robust variance-covariance matrix.
}
\description{
This method for \code{\link[sandwich]{vcovHC}} computes the cluster-robust 
variance-covariance matrix for a \code{glmmTMB} model fitted with ML.
}
\details{
The sandwich estimator is computed as \code{B * M * B} where
  \code{B} is the bread matrix and \code{M} is the meat matrix.
  The bread matrix is just the usual inverse Hessian obtained by
  \code{vcov()}. The meat matrix is calculated as the sum of the cluster-wise
  score vector cross-products.
}
\examples{
m <- glmmTMB(count ~ mined + (1 | spp), data = Salamanders, family = nbinom1)

# Standard variance-covariance matrix:
vcov(m)$cond

# Cluster-robust variance-covariance matrix:
vcovHC(m)

# Include the variance parameters:
vcovHC(m, full = TRUE)

# This can be compared with:
vcov(m, full = TRUE)

# Only look at the meat part:
vcovHC(m, sandwich = FALSE)
}
