% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_sided.R
\name{monte_carlo_two_sided}
\alias{monte_carlo_two_sided}
\title{Monte Carlo Simulation for Two-Sided Test}
\usage{
monte_carlo_two_sided(lower_bounds, upper_bounds, num_sims = 1e+06)
}
\arguments{
\item{lower_bounds}{Numeric vector where the ith component is the lower bound
for the ith order statistic. The components must be distinct values in (0, 1) that
are in ascending order.}

\item{upper_bounds}{Numeric vector where the ith component is the lower bound
for the ith order statistic. The values must be in ascending order and
the ith component must be larger than the ith component of the lower bounds.}

\item{num_sims}{(optional) Number of simulations to be run, 1 Million by default.}
}
\value{
Type I Error Rate \eqn{\alpha}
}
\description{
Given bounds for a two sided test on uniform order statistics, this computes
the Type I Error Rate \eqn{\alpha} using simulations.
}
