% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_cleanup.R
\name{cleanup_files}
\alias{cleanup_files}
\title{Deletes temporary files associated with a Slurm job}
\usage{
cleanup_files(slr_job, wait = TRUE)
}
\arguments{
\item{slr_job}{A \code{slurm_job} object.}

\item{wait}{Specify whether to block until \code{slr_job} completes.}
}
\description{
This function deletes all temporary files associated with the specified Slurm
job, including files created by \code{\link{slurm_apply}} or 
\code{\link{slurm_call}}, as well as outputs from the cluster. These files
should be located in the \emph{_rslurm_[jobname]} folder of the current
working directory.
}
\examples{
\dontrun{
sjob <- slurm_apply(func, pars)
print_job_status(sjob) # Prints console/error output once job is completed.
func_result <- get_slurm_out(sjob, "table") # Loads output data into R.
cleanup_files(sjob)
}
}
\seealso{
\code{\link{slurm_apply}}, \code{\link{slurm_call}}
}
