% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow_search.R
\name{pow_lookup}
\alias{pow_lookup}
\title{Lookup taxa in Kew's Plants of the World}
\usage{
pow_lookup(id, include = NULL, ...)
}
\arguments{
\item{id}{(character) taxon id. required}

\item{include}{(character) vector of additional fields to include in
results. options include 'distribution' and 'descriptions'. optional}

\item{...}{Further args passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\description{
Lookup taxa in Kew's Plants of the World
}
\examples{
\dontrun{
pow_lookup(id = 'urn:lsid:ipni.org:names:320035-2')
pow_lookup(id = 'urn:lsid:ipni.org:names:320035-2',
  include = "distribution")
pow_lookup(id = 'urn:lsid:ipni.org:names:320035-2',
  include = c("distribution", "descriptions"))
}
}
\seealso{
Other pow: 
\code{\link{get_pow}()},
\code{\link{pow_search}()},
\code{\link{pow_synonyms}()}
}
\concept{pow}
