/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.HelpCloseDialog;

public class EditRunDialog
extends HelpCloseDialog {
    String Filename;
    ZirkelFrame ZF;
    TextArea Text;

    public EditRunDialog(ZirkelFrame zirkelFrame, String string) {
        super(zirkelFrame, Zirkel.name("editrun.title"), true);
        this.Filename = string;
        this.ZF = zirkelFrame;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.add(new MyLabel(string));
        this.add("North", new Panel3D(myPanel));
        this.Text = new TextArea(30, 60);
        this.add("Center", new Panel3D(this.Text));
        if (Global.FixedFont != null) {
            this.Text.setFont(Global.FixedFont);
        }
        this.load(string);
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(new ButtonAction(this, Zirkel.name("editrun.run"), "Run"));
        myPanel2.add(new ButtonAction(this, Zirkel.name("editrun.load"), "Load"));
        myPanel2.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(myPanel2, "visual");
        this.add("South", new Panel3D(myPanel2));
        this.setSize("editrun");
        this.center(zirkelFrame);
    }

    public void doAction(String string) {
        this.noteSize("editrun");
        if (string.equals("Run")) {
            this.doclose();
            try {
                this.save(this.Filename);
            }
            catch (Exception exception) {
                Warning warning = new Warning((Frame)this.ZF, Zirkel.name("editrun.error"), Zirkel.name("warning"), true);
                warning.center(this.ZF);
                warning.setVisible(true);
                return;
            }
            this.ZF.loadRun(this.Filename);
        } else if (string.equals("Load")) {
            this.doclose();
            this.ZF.editRun("");
        } else {
            super.doAction(string);
        }
    }

    public void load(String string) {
        this.Text.setText("");
        this.Text.setEnabled(false);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.Text.append(string2 + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Text.setEnabled(true);
        this.Text.repaint();
    }

    public void save(String string) throws IOException {
        String string2 = this.Text.getText();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(string)));
        printWriter.print(string2);
        printWriter.close();
    }
}

