/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.builder;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationsJacksonBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationsJacksonBuilder.class);
    private List<Application> applications;
    private long version;
    private String appsHashCode;

    @JsonProperty(value="application")
    public void withApplication(List<Application> applications) {
        this.applications = applications;
    }

    @JsonAnySetter
    public void with(String fieldName, Object value) {
        if (fieldName == null || value == null) {
            return;
        }
        if (fieldName.startsWith("version")) {
            try {
                this.version = value instanceof Number ? ((Number)value).longValue() : Long.parseLong((String)value);
            }
            catch (Exception e) {
                this.version = -1L;
                logger.warn("Cannot parse version number {}; setting it to default == -1", value);
            }
        } else if (fieldName.startsWith("apps")) {
            if (value instanceof String) {
                this.appsHashCode = (String)value;
            } else {
                logger.warn("appsHashCode field is not a string, but {}", value.getClass());
            }
        }
    }

    public Applications build() {
        return new Applications(this.appsHashCode, this.version, this.applications);
    }
}

