import dataclasses
from collections.abc import Sequence

from debian.deb822 import PkgRelation

from debputy.manifest_conditions import ManifestCondition
from debputy.manifest_parser.base_types import FileSystemMode
from debputy.manifest_parser.util import AttributePath


@dataclasses.dataclass(slots=True)
class DebputyCapability:
    capabilities: str
    capability_mode: FileSystemMode
    definition_source: str


@dataclasses.dataclass(slots=True)
class MatchedBuiltUsingRelation:
    name: str
    is_first: bool
    relationship: "PkgRelation.ParsedRelation"


@dataclasses.dataclass(slots=True)
class BuiltUsingBase:
    sources_for: str
    matched_packages: Sequence[MatchedBuiltUsingRelation]
    conditional: ManifestCondition | None
    attribute_path: AttributePath

    @classmethod
    def field_name(cls) -> str:
        raise NotImplementedError


class StaticBuiltUsing(BuiltUsingBase):
    @classmethod
    def field_name(cls) -> str:
        return "Static-Built-Using"


class BuiltUsing(BuiltUsingBase):
    @classmethod
    def field_name(cls) -> str:
        return "Built-Using"
