# Package list of Release 22.0.0
## Prebuilt Packages

Iosevka provides a large variety of variants. Prebuilt variants are listed below. For all Monospace variants' packages, it will contain three _spacing variants_. You can either download the package containing all the spacing variants (recommended), or cherry-pick the variant with specific spacing.
  - _Default_: The default variant with ligatures. Various symbols, like arrows and geometric, are wide (2-column).
  - _Terminal_ (“Term”)：A narrower variant focusing terminal uses. Arrows and geometric symbols will be narrow to follow typical terminal usages.
  - _Fixed_: Exact monospace font without ligatures and wide glyphs. Since some environments cannot interpret Iosevka or Iosevka Term as monospace, and have difficulties with ligatures included, you can use Iosevka Fixed as an alternative.

## Packaging Formats

Iosevka provides various packaging formats, here is the list of them:

| Option         | Contents                                            | Description                                                  |
| -------------- | --------------------------------------------------- | ------------------------------------------------------------ |
| Super TTC | 1 `.ttc` file                                       | Bundles all fonts in the scope together into a single file. It is the recommended way to install fonts for Desktop usage, if your operating system is updated to date. Package files with `-sgr-` infix in the filename only contains fonts for one single group (variant and spacing). |
| TTC            | 9 `.ttc` files                                      | Each TTC file bundles fonts with the same weight together.  Package files with `-sgr-` infix in the filename only contains fonts for one single group (variant and spacing).   |
| TTF            | 54 `.ttf` files                                     | Each TTF file contains one font for a specific weight, width, slope and spacing variant. This option is ideal for embedding Iosevka into applications, or for desktop usage if TTC options have compatibility issues.<br/>TTF packages also provide *unhinted* version which removes [hints](https://en.wikipedia.org/wiki/Font_hinting), which reduced file size, but will be less clear on certain platforms. |
| WebFont        | 1 `.css` file + 54 `.woff2` files + 54 `.ttf` files | Contains contents required to use Iosevka on websites.       |


<table>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka</b> — <i>Monospace, Default</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Slab</b> — <i>Monospace, Slab-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-slab-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-slab-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Slab</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Slab</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Slab</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-slab.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-slab.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Curly</b> — <i>Monospace, Curly Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-curly-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-curly-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Curly</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-curly-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-curly-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-curly-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-curly-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-curly-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-curly-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Curly</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-curly-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-curly-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-curly-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-curly-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-curly-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-curly-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Curly</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-curly-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-curly-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-curly-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-curly-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-curly-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-curly-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-curly.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-curly.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Curly Slab</b> — <i>Monospace, Curly Style, Slab-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-curly-slab-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-curly-slab-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Curly Slab</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-curly-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-curly-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-curly-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-curly-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-curly-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-curly-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Curly Slab</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-curly-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-curly-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-curly-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-curly-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-curly-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-curly-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Curly Slab</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-curly-slab-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-curly-slab-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-curly-slab-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-curly-slab-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-curly-slab-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-curly-slab-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-curly-slab.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-curly-slab.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS01</b> — <i>Monospace, Andale Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss01-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss01-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS01</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss01-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss01-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss01-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss01-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss01-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss01-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS01</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss01-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss01-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss01-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss01-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss01-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss01-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS01</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss01-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss01-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss01-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss01-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss01-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss01-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss01.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss01.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS02</b> — <i>Monospace, Anonymous Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss02-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss02-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS02</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss02-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss02-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss02-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss02-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss02-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss02-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS02</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss02-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss02-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss02-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss02-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss02-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss02-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS02</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss02-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss02-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss02-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss02-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss02-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss02-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss02.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss02.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS03</b> — <i>Monospace, Consolas Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss03-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss03-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS03</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss03-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss03-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss03-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss03-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss03-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss03-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS03</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss03-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss03-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss03-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss03-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss03-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss03-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS03</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss03-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss03-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss03-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss03-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss03-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss03-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss03.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss03.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS04</b> — <i>Monospace, Menlo Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss04-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss04-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS04</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss04-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss04-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss04-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss04-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss04-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss04-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS04</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss04-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss04-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss04-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss04-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss04-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss04-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS04</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss04-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss04-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss04-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss04-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss04-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss04-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss04.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss04.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS05</b> — <i>Monospace, Fira Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss05-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss05-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS05</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss05-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss05-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss05-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss05-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss05-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss05-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS05</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss05-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss05-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss05-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss05-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss05-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss05-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS05</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss05-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss05-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss05-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss05-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss05-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss05-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss05.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss05.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS06</b> — <i>Monospace, Liberation Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss06-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss06-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS06</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss06-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss06-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss06-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss06-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss06-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss06-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS06</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss06-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss06-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss06-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss06-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss06-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss06-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS06</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss06-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss06-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss06-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss06-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss06-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss06-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss06.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss06.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS07</b> — <i>Monospace, Monaco Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss07-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss07-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS07</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss07-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss07-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss07-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss07-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss07-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss07-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS07</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss07-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss07-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss07-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss07-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss07-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss07-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS07</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss07-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss07-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss07-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss07-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss07-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss07-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss07.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss07.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS08</b> — <i>Monospace, Pragmata Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss08-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss08-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS08</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss08-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss08-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss08-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss08-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss08-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss08-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS08</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss08-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss08-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss08-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss08-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss08-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss08-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS08</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss08-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss08-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss08-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss08-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss08-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss08-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss08.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss08.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS09</b> — <i>Monospace, Source Code Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss09-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss09-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS09</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss09-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss09-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss09-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss09-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss09-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss09-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS09</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss09-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss09-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss09-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss09-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss09-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss09-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS09</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss09-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss09-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss09-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss09-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss09-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss09-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss09.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss09.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS10</b> — <i>Monospace, Envy Code R Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss10-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss10-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS10</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss10-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss10-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss10-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss10-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss10-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss10-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS10</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss10-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss10-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss10-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss10-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss10-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss10-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS10</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss10-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss10-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss10-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss10-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss10-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss10-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss10.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss10.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS11</b> — <i>Monospace, X Windows Fixed Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss11-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss11-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS11</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss11-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss11-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss11-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss11-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss11-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss11-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS11</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss11-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss11-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss11-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss11-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss11-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss11-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS11</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss11-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss11-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss11-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss11-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss11-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss11-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss11.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss11.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS12</b> — <i>Monospace, Ubuntu Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss12-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss12-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS12</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss12-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss12-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss12-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss12-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss12-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss12-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS12</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss12-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss12-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss12-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss12-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss12-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss12-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS12</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss12-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss12-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss12-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss12-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss12-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss12-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss12.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss12.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS13</b> — <i>Monospace, Lucida Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss13-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss13-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS13</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss13-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss13-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss13-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss13-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss13-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss13-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS13</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss13-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss13-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss13-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss13-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss13-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss13-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS13</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss13-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss13-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss13-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss13-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss13-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss13-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss13.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss13.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS14</b> — <i>Monospace, JetBrains Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss14-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss14-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS14</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss14-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss14-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss14-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss14-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss14-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss14-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS14</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss14-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss14-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss14-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss14-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss14-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss14-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS14</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss14-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss14-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss14-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss14-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss14-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss14-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss14.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss14.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS15</b> — <i>Monospace, IBM Plex Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss15-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss15-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS15</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss15-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss15-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss15-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss15-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss15-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss15-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS15</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss15-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss15-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss15-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss15-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss15-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss15-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS15</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss15-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss15-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss15-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss15-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss15-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss15-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss15.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss15.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS16</b> — <i>Monospace, PT Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss16-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss16-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS16</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss16-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss16-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss16-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss16-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss16-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss16-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS16</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss16-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss16-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss16-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss16-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss16-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss16-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS16</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss16-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss16-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss16-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss16-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss16-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss16-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss16.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss16.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS17</b> — <i>Monospace, Recursive Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss17-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss17-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS17</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss17-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss17-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss17-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss17-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss17-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss17-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS17</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss17-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss17-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss17-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss17-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss17-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss17-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS17</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss17-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss17-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss17-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss17-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss17-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss17-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss17.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss17.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS18</b> — <i>Monospace, Input Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-ss18-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-ss18-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS18</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-ss18-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-ss18-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-ss18-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-ss18-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-ss18-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-ss18-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS18</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-term-ss18-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-term-ss18-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-term-ss18-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-term-ss18-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-term-ss18-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-term-ss18-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS18</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-fixed-ss18-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-fixed-ss18-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-fixed-ss18-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-fixed-ss18-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-fixed-ss18-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-fixed-ss18-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss18.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-ss18.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Aile</b> — <i>Quasi-proportional, Sans-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-aile-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-aile-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Aile</b></td><td>Default</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-aile-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-aile-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-aile-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-aile-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-aile-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-aile-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-aile.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-aile.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Etoile</b> — <i>Quasi-proportional, Slab-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-iosevka-etoile-22.0.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-iosevka-etoile-22.0.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Etoile</b></td><td>Default</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/super-ttc-sgr-iosevka-etoile-22.0.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttc-sgr-iosevka-etoile-22.0.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-iosevka-etoile-22.0.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/ttf-unhinted-iosevka-etoile-22.0.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-iosevka-etoile-22.0.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v22.0.0/webfont-unhinted-iosevka-etoile-22.0.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-etoile.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v22.0.0/images/iosevka-etoile.dark.svg#gh-dark-mode-only"/></td></tr>
</table>

