"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prime = exports.mergeMapAlt = exports.mergeMap = exports.mergeMapOpt = exports.combineList = void 0;
function combineList(a, b) {
    return [...(a || []), ...(a || [])];
}
exports.combineList = combineList;
function mergeMapOpt(preferred, less, mergeValue) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    return mergeMap(preferred, less, mergeValue);
}
exports.mergeMapOpt = mergeMapOpt;
function mergeMap(preferred, less, mergeValue) {
    const m = new Map(preferred);
    for (const [k, v] of less) {
        if (m.has(k)) {
            m.set(k, mergeValue(m.get(k), v));
        }
        else {
            m.set(k, v);
        }
    }
    return m;
}
exports.mergeMap = mergeMap;
function mergeMapAlt(preferred, less, mergeValue) {
    const keySet = new Set([...preferred.keys(), ...less.keys()]);
    const m = new Map();
    for (const k of keySet) {
        m.set(k, mergeValue(preferred.get(k), less.get(k)));
    }
    return m;
}
exports.mergeMapAlt = mergeMapAlt;
function Prime(a, b) {
    return a;
}
exports.Prime = Prime;
//# sourceMappingURL=utils.js.map