"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rebaseFont = void 0;
const Ot = require("@ot-builder/ot");
const Rectify = require("@ot-builder/rectify");
const point_rectifier_1 = require("../support/point-rectifier");
function rebaseFont(font, newUpm) {
    Rectify.inPlaceRectifyFont({ glyphRef: g => g }, createAxisRectifier(), createValueRectifier(newUpm, font.head.unitsPerEm), new point_rectifier_1.StdPointAttachRectifier(Rectify.PointAttachmentRectifyManner.TrustAttachment), font);
    font.head.unitsPerEm = newUpm;
}
exports.rebaseFont = rebaseFont;
function createAxisRectifier() {
    return {
        dim: a => a,
        axis: a => a,
        addedAxes: []
    };
}
function createValueRectifier(newUpm, oldUpm) {
    return {
        coord: x => Ot.Var.Ops.scale(newUpm / oldUpm, x),
        cv: x => Ot.Var.Ops.scale(newUpm / oldUpm, x)
    };
}
//# sourceMappingURL=rebase.js.map