"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValueProcessor = exports.MasterProcessor = exports.DimMapper = void 0;
const Ot = require("@ot-builder/ot");
class DimMapper {
    constructor() {
        this.nAxes = 0;
        this.mapping = new WeakMap();
        this.reverseMapping = [];
    }
    put(dim) {
        let aid = this.mapping.get(dim);
        if (aid != null)
            return aid;
        aid = this.nAxes++;
        this.mapping.set(dim, aid);
        this.reverseMapping[aid] = dim;
        return aid;
    }
    alias(dim, existing) {
        let aid = this.mapping.get(existing);
        if (aid == null)
            aid = this.put(existing);
        this.mapping.set(dim, aid);
        return aid;
    }
    reverse(aid) {
        return this.reverseMapping[aid];
    }
}
exports.DimMapper = DimMapper;
class MasterProcessor {
    constructor(dm) {
        this.dm = dm;
    }
    toArrayRep(master) {
        const steps = [];
        for (const region of master.regions) {
            const aid = this.dm.put(region.dim);
            steps[aid] = [region.min, region.peak, region.max];
        }
        const stepNumbers = [];
        for (let aid = 0; aid < steps.length; aid++) {
            const step = steps[aid];
            if (step)
                stepNumbers.push(aid, step[0], step[1], step[2]);
        }
        return stepNumbers;
    }
    toUniqueMaster(master) {
        const steps = [];
        for (const region of master.regions) {
            const aid = this.dm.put(region.dim);
            steps[aid] = {
                dim: this.dm.reverse(aid),
                min: region.min,
                peak: region.peak,
                max: region.max
            };
        }
        return new Ot.Var.Master(steps);
    }
}
exports.MasterProcessor = MasterProcessor;
class ValueProcessor {
    constructor(mp) {
        this.mp = mp;
        this.cr = new Ot.Var.ValueFactory();
    }
    toArrayRep(v) {
        const variances = Array.from(Ot.Var.Ops.varianceOf(v));
        const rep = [Ot.Var.Ops.originOf(v)];
        const varianceReps = [];
        for (const [master, delta] of variances) {
            if (!delta)
                continue;
            const rep = this.mp.toArrayRep(master);
            varianceReps.push([delta, rep.length, ...rep]);
        }
        varianceReps.sort(ValueProcessor.compareArray);
        rep.push(varianceReps.length);
        for (const vRep of varianceReps) {
            for (const item of vRep) {
                rep.push(item);
            }
        }
        return rep;
    }
    toUniqueValue(v) {
        if (Ot.Var.Ops.isConstant(v))
            return v;
        const origin = Ot.Var.Ops.originOf(v);
        const variance = [];
        for (const [master, delta] of Ot.Var.Ops.varianceOf(v)) {
            if (delta) {
                variance.push([this.mp.toUniqueMaster(master), delta]);
            }
        }
        return this.cr.create(origin, variance);
    }
    static compareArray(a, b) {
        for (let index = 0; index < a.length && index < b.length; index++) {
            if (a[index] === b[index]) {
                continue;
            }
            else {
                return a[index] - b[index];
            }
        }
        return a.length - b.length;
    }
}
exports.ValueProcessor = ValueProcessor;
//# sourceMappingURL=value-process.js.map