"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffBufferIndex = exports.CffSubroutineIndex = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const read_1 = require("../../cff-index/read");
const write_1 = require("../../cff-index/write");
exports.CffSubroutineIndex = {
    ...(0, bin_util_1.Read)((view, ctx) => {
        return view.next(new read_1.CffReadIndex({ read: (view, ctx, size) => view.bytes(size) }), ctx);
    }),
    ...(0, bin_util_1.Write)((frag, subrs, ctx) => {
        frag.push(new write_1.CffWriteIndex({ write: (f, item, ctx) => f.bytes(item) }), subrs, ctx);
    })
};
exports.CffBufferIndex = exports.CffSubroutineIndex;
//# sourceMappingURL=subroutine-index.js.map