"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffGlyphStatSink = exports.Cff2Limits = exports.Cff1Limits = exports.CffWriteContext = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const var_store_1 = require("@ot-builder/var-store");
const variance_1 = require("@ot-builder/variance");
const sink_1 = require("../strings/sink");
class CffWriteContext {
    constructor(version, upm, acceptVariation = true, gss = null) {
        this.version = version;
        this.upm = upm;
        this.ivs = null;
        this.strings = null;
        if (version > 1 && acceptVariation)
            this.ivs = var_store_1.WriteTimeIVS.create(new variance_1.OtVar.MasterSet());
        if (version <= 1)
            this.strings = new sink_1.CffStringSink();
        this.stat = new CffGlyphStatSink(gss);
    }
    getLimits() {
        if (this.version <= 1)
            return exports.Cff1Limits;
        else
            return exports.Cff2Limits;
    }
}
exports.CffWriteContext = CffWriteContext;
exports.Cff1Limits = {
    maxStack: 48,
    maxRecursion: 10,
    maxSubrs: 60000,
    retSize: 1,
    endCharSize: 1
};
exports.Cff2Limits = {
    maxStack: 512,
    maxRecursion: 10,
    maxSubrs: 60000,
    retSize: 0,
    endCharSize: 0
};
class CffGlyphStatSink {
    constructor(outer) {
        this.outer = outer;
        this.fontBBox = new ot_glyphs_1.OtGlyph.Stat.BoundingBoxBuilder();
    }
    setMetric(gid, horizontal, vertical, extent) {
        if (this.outer)
            this.outer.setMetric(gid, horizontal, vertical, extent);
    }
    setNumGlyphs(count) {
        if (this.outer)
            this.outer.setNumGlyphs(count);
    }
    simpleGlyphStat(st) {
        this.fontBBox.addBox(st.extent);
        if (this.outer)
            this.outer.simpleGlyphStat(st);
    }
    complexGlyphStat(st) {
        this.fontBBox.addBox(st.extent);
        if (this.outer)
            this.outer.complexGlyphStat(st);
    }
    instructionsStat(size) {
        if (this.outer)
            this.outer.instructionsStat(size);
    }
    settle() {
        if (this.outer)
            this.outer.settle();
    }
}
exports.CffGlyphStatSink = CffGlyphStatSink;
//# sourceMappingURL=write.js.map