"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LookupWriteTrick = exports.createConfig = void 0;
const IoBinEncoding = require("@ot-builder/io-bin-encoding");
const IoBinExtPrivate = require("@ot-builder/io-bin-ext-private");
const IoBinGlyphStore = require("@ot-builder/io-bin-glyph-store");
const IoBinLayout = require("@ot-builder/io-bin-layout");
const IoBinMetadata = require("@ot-builder/io-bin-metadata");
const IoBinVttPrivate = require("@ot-builder/io-bin-vtt-private");
function createConfig(partial) {
    return {
        cff: { ...IoBinGlyphStore.DefaultCffCfgProps, ...partial.cff },
        ttf: { ...IoBinGlyphStore.DefaultTtfCfgProps, ...partial.ttf },
        fontMetadata: { ...IoBinMetadata.DefaultFontMetadataCfgProps, ...partial.fontMetadata },
        glyphStore: { ...IoBinGlyphStore.DefaultGlyphStoreCfgProps, ...partial.glyphStore },
        glyphNaming: { ...IoBinGlyphStore.DefaultGlyphNamingCfgProps, ...partial.glyphNaming },
        encoding: { ...IoBinEncoding.DefaultEncodingCfgProps, ...partial.encoding },
        layout: { ...IoBinLayout.DefaultLayoutProps, ...partial.layout },
        extPrivate: { ...IoBinExtPrivate.DefaultExtPrivateCfgProps, ...partial.extPrivate },
        vttPrivate: { ...IoBinVttPrivate.DefaultVttPrivateCfgProps, ...partial.vttPrivate },
        generateDummyDigitalSignature: !!partial.generateDummyDigitalSignature
    };
}
exports.createConfig = createConfig;
var io_bin_layout_1 = require("@ot-builder/io-bin-layout");
Object.defineProperty(exports, "LookupWriteTrick", { enumerable: true, get: function () { return io_bin_layout_1.LookupWriteTrick; } });
//# sourceMappingURL=config.js.map