"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CFeatureList = exports.CFeatureTable = void 0;
const primitive_1 = require("@ot-builder/primitive");
const feature_param_1 = require("./feature-param");
class CFeatureTable {
    read(view, lOrd, tag) {
        const vFeatureParams = view.ptr16Nullable();
        let featureParams = undefined;
        if (vFeatureParams)
            featureParams = vFeatureParams.next(feature_param_1.FeatureParams, tag);
        const lookups = view.array(view.uint16(), primitive_1.UInt16).map(x => lOrd.at(x));
        return { tag, lookups, params: featureParams };
    }
    write(frag, feat, lOrd) {
        frag.ptr16(feature_param_1.FeatureParams.writeOpt(feat.params, feat.tag));
        frag.uint16(feat.lookups.length);
        for (const lookup of feat.lookups)
            frag.uint16(lOrd.reverse(lookup));
    }
}
exports.CFeatureTable = CFeatureTable;
class CFeatureList {
    read(view, lOrd) {
        const featureCount = view.uint16();
        const features = [];
        const readFeatureTable = new CFeatureTable();
        for (let fid = 0; fid < featureCount; fid++) {
            const tag = view.next(primitive_1.Tag);
            features.push(view.ptr16().next(readFeatureTable, lOrd, tag));
        }
        return features;
    }
    write(frag, featureList, lOrd) {
        frag.uint16(featureList.length);
        const writer = new CFeatureTable();
        for (const feature of featureList) {
            frag.push(primitive_1.Tag, feature.tag);
            frag.ptr16New().push(writer, feature, lOrd);
        }
    }
}
exports.CFeatureList = CFeatureList;
//# sourceMappingURL=feature-list.js.map