import { BinaryView, Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gpos } from "@ot-builder/ot-layout";
import { LookupReader, LookupWriter, SubtableReadingContext, SubtableWriteContext } from "../gsub-gpos-shared/general";
export declare class GposCursiveReader implements LookupReader<Gpos.Lookup, Gpos.Cursive> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.Cursive, Gpos.CursiveProp>;
    parseSubtable(view: BinaryView, lookup: Gpos.Cursive, context: SubtableReadingContext<Gpos.Lookup>): void;
}
declare class State {
    mapping: Map<OtGlyph, Gpos.CursiveAnchorPair>;
    size: number;
    tryAddMapping(from: OtGlyph, to: Gpos.CursiveAnchorPair): boolean;
}
export declare class GposCursiveWriter implements LookupWriter<Gpos.Lookup, Gpos.Cursive> {
    canBeUsed(l: Gpos.Lookup): l is Gpos.Cursive;
    getLookupType(): number;
    getLookupTypeSymbol(): symbol;
    flush(frags: Frag[], state: State, ctx: SubtableWriteContext<Gpos.Lookup>): void;
    createSubtableFragments(lookup: Gpos.Cursive, ctx: SubtableWriteContext<Gpos.Lookup>): Frag[];
}
export {};
//# sourceMappingURL=gpos-cursive.d.ts.map