"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readOtl = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_layout_1 = require("@ot-builder/ot-layout");
const base_1 = require("../base");
const gdef_1 = require("../gdef");
const gpos_1 = require("../gpos");
const gsub_1 = require("../gsub");
const math_1 = require("../math");
function readOtl(sfnt, cfg, gOrd, md) {
    let gdef = null;
    let ivs = null;
    const bGdef = sfnt.tables.get(ot_layout_1.Gdef.Tag);
    const bGsub = sfnt.tables.get(ot_layout_1.Gsub.Tag);
    const bGpos = sfnt.tables.get(ot_layout_1.Gpos.Tag);
    const designSpace = md.fvar ? md.fvar.getDesignSpace() : null;
    if (bGdef) {
        const res = new bin_util_1.BinaryView(bGdef).next(gdef_1.GdefTableIo, gOrd, designSpace);
        gdef = res.gdef;
        ivs = res.ivs;
    }
    let gsub = null;
    let gpos = null;
    const trc = { gOrd, gdef, designSpace, ivs };
    if (bGsub)
        gsub = new bin_util_1.BinaryView(bGsub).next(gsub_1.GsubTableIo, cfg, trc);
    if (bGpos)
        gpos = new bin_util_1.BinaryView(bGpos).next(gpos_1.GposTableIo, cfg, trc);
    const bBase = sfnt.tables.get(ot_layout_1.Base.Tag);
    const base = bBase ? new bin_util_1.BinaryView(bBase).next(base_1.BaseTableIo, gOrd, designSpace) : null;
    const bMath = sfnt.tables.get(ot_layout_1.Math.Tag);
    const math = bMath ? new bin_util_1.BinaryView(bMath).next(math_1.MathTableIo, gOrd) : null;
    return { gdef, gsub, gpos, base, math };
}
exports.readOtl = readOtl;
//# sourceMappingURL=read.js.map