import { BinaryView, Frag, Read, Write } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { LayoutCommon } from "@ot-builder/ot-layout";
import { Data } from "@ot-builder/prelude";
export declare const MaxClsDefItemWords = 3;
export declare namespace ClassDefUtil {
    function padClass0<G>(cd: LayoutCommon.ClassDef.T<G>, gs: Iterable<G>): void;
    function limitToCov<G>(cd: LayoutCommon.ClassDef.T<G>, cov: LayoutCommon.Coverage.T<G>): void;
    function SplitClassDef<G>(cd: LayoutCommon.ClassDef.T<G>): G[][];
    function getClassCount<G>(cd: LayoutCommon.ClassDef.T<G>): number;
    function select<G>(targetCls: number, cd: LayoutCommon.ClassDef.T<G>, cov?: null | LayoutCommon.Coverage.T<G>): Set<G>;
}
export declare const ClassDef: {
    read(view: BinaryView, gOrd: Data.Order<OtGlyph>): LayoutCommon.ClassDef.T<OtGlyph>;
    write(frag: Frag, cd: Iterable<[OtGlyph, number]>, gOrd: Data.Order<OtGlyph>, trick?: number): void;
};
export declare const Ptr16ClassDef: Read<LayoutCommon.ClassDef.T<OtGlyph>, [gOrd: Data.Order<OtGlyph>]> & Write<Iterable<[OtGlyph, number]>, [gOrd: Data.Order<OtGlyph>, trick?: number | undefined]>;
export declare const NullablePtr16ClassDef: Read<LayoutCommon.ClassDef.T<OtGlyph> | null | undefined, [gOrd: Data.Order<OtGlyph>]> & Write<Iterable<[OtGlyph, number]> | null | undefined, [gOrd: Data.Order<OtGlyph>, trick?: number | undefined]>;
export declare const EmptyAsNullPtr16ClassDef: {
    read(view: BinaryView, gOrd: Data.Order<OtGlyph>): Map<OtGlyph, number>;
    write(frag: Frag, cd: Map<OtGlyph, number>, gOrd: Data.Order<OtGlyph>, trick?: number): void;
};
export declare const GidClassDef: {
    write(target: Frag, t: Iterable<[number, number]>, trick?: number | undefined): void;
    read(view: BinaryView): Map<number, number>;
};
//# sourceMappingURL=class-def.d.ts.map