"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricHeadIo = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const variance_1 = require("@ot-builder/variance");
exports.MetricHeadIo = {
    ...(0, bin_util_1.Read)((view, vertical) => {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        const table = vertical
            ? new ot_metadata_1.MetricHead.Vhea(majorVersion, minorVersion)
            : new ot_metadata_1.MetricHead.Hhea(majorVersion, minorVersion);
        table.ascender = view.int16();
        table.descender = view.int16();
        table.lineGap = view.int16();
        table.advanceMax = view.uint16();
        table.minStartSideBearing = view.int16();
        table.minEndSideBearing = view.int16();
        table.maxExtent = view.int16();
        table.caretSlopeRise = view.int16();
        table.caretSlopeRun = view.int16();
        table.caretOffset = view.int16();
        table._reserved0 = view.int16();
        table._reserved1 = view.int16();
        table._reserved2 = view.int16();
        table._reserved3 = view.int16();
        const _metricDataFormat = view.uint16();
        table.numberOfLongMetrics = view.uint16();
        return table;
    }),
    ...(0, bin_util_1.Write)((frag, table) => {
        frag.uint16(table.majorVersion);
        frag.uint16(table.minorVersion);
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.ascender)));
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.descender)));
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.lineGap)));
        frag.uint16(table.advanceMax);
        frag.int16(table.minStartSideBearing);
        frag.int16(table.minEndSideBearing);
        frag.int16(table.maxExtent);
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.caretSlopeRise)));
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.caretSlopeRun)));
        frag.int16(Math.round(variance_1.OtVar.Ops.originOf(table.caretOffset)));
        frag.int16(table._reserved0);
        frag.int16(table._reserved1);
        frag.int16(table._reserved2);
        frag.int16(table._reserved3);
        frag.int16(table.metricDataFormat);
        frag.uint16(table.numberOfLongMetrics);
    })
};
//# sourceMappingURL=index.js.map