"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeNames = exports.readNames = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_name_1 = require("@ot-builder/ot-name");
const meta_1 = require("../meta");
const name_1 = require("../name");
const read_1 = require("../stat/read");
const write_1 = require("../stat/write");
function readNames(sfnt) {
    const bufName = sfnt.tables.get(ot_name_1.Name.Tag);
    const name = bufName ? new bin_util_1.BinaryView(bufName).next(name_1.NameIo) : null;
    const bufStat = sfnt.tables.get(ot_name_1.Stat.Tag);
    const stat = bufStat ? new bin_util_1.BinaryView(bufStat).next(read_1.StatRead) : null;
    const bufMeta = sfnt.tables.get(ot_name_1.Meta.Tag);
    const meta = bufMeta ? new bin_util_1.BinaryView(bufMeta).next(meta_1.MetaTableIo) : null;
    return { name, stat, meta };
}
exports.readNames = readNames;
function writeNames(sink, nd) {
    if (nd.name)
        sink.add(ot_name_1.Name.Tag, bin_util_1.Frag.packFrom(name_1.NameIo, nd.name));
    if (nd.stat)
        sink.add(ot_name_1.Stat.Tag, bin_util_1.Frag.packFrom(write_1.StatWrite, nd.stat));
    if (nd.meta)
        sink.add(ot_name_1.Meta.Tag, bin_util_1.Frag.packFrom(meta_1.MetaTableIo, nd.meta));
}
exports.writeNames = writeNames;
//# sourceMappingURL=index.js.map