"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readTSI0123 = void 0;
const ot_vtt_private_1 = require("@ot-builder/ot-vtt-private");
const primitive_1 = require("@ot-builder/primitive");
function readTSI0123(viewTable02, viewTable13, gOrd) {
    const sizeOfTSI02Record = primitive_1.UInt16.size * 2 + primitive_1.UInt32.size; // 8 bytes
    const totalRecords = viewTable02.sourceBufferSize / sizeOfTSI02Record;
    const offsetRecords = [];
    for (let index = 0; index < totalRecords; index++) {
        const glyphIndex = viewTable02.uint16();
        const textLength = viewTable02.uint16();
        const textOffset = viewTable02.uint32();
        if (glyphIndex === 0xfffe)
            continue;
        offsetRecords.push({ glyphIndex, textLength, textOffset });
    }
    const sink = new ot_vtt_private_1.TSI0123.Table();
    for (let index = 0; index < offsetRecords.length; index++) {
        const rec = offsetRecords[index];
        const nextOffset = index + 1 < offsetRecords.length
            ? offsetRecords[index + 1].textOffset
            : viewTable13.sourceBufferSize;
        const textLength = rec.textLength < 0x8000 ? rec.textLength : nextOffset - rec.textOffset;
        const text = viewTable13.lift(rec.textOffset).bytes(textLength).toString("utf-8");
        switch (rec.glyphIndex) {
            case 0xfffa:
                sink.preProgram = text;
                break;
            case 0xfffb:
                sink.cvtProgram = text;
                break;
            case 0xfffc:
                break;
            case 0xfffd:
                sink.fpgmProgram = text;
                break;
            default:
                sink.glyphPrograms.set(gOrd.at(rec.glyphIndex), text);
        }
    }
    return sink;
}
exports.readTSI0123 = readTSI0123;
//# sourceMappingURL=read.js.map