"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.Instance = exports.InstanceFlags = exports.Axis = exports.AxisFlags = exports.Tag = void 0;
const ImpLib = require("@ot-builder/common-impl");
exports.Tag = "fvar";
var AxisFlags;
(function (AxisFlags) {
    AxisFlags[AxisFlags["Default"] = 0] = "Default";
    AxisFlags[AxisFlags["Hidden"] = 1] = "Hidden";
})(AxisFlags = exports.AxisFlags || (exports.AxisFlags = {}));
class Axis {
    constructor(dim, flags, axisNameID) {
        this.dim = dim;
        this.flags = flags;
        this.axisNameID = axisNameID;
    }
}
exports.Axis = Axis;
var InstanceFlags;
(function (InstanceFlags) {
    InstanceFlags[InstanceFlags["Default"] = 0] = "Default";
})(InstanceFlags = exports.InstanceFlags || (exports.InstanceFlags = {}));
class Instance {
    constructor(subfamilyNameID, flags, coordinates, postScriptNameID) {
        this.subfamilyNameID = subfamilyNameID;
        this.flags = flags;
        this.coordinates = coordinates;
        this.postScriptNameID = postScriptNameID;
    }
}
exports.Instance = Instance;
class Table {
    constructor(axes = [], instances = []) {
        this.axes = axes;
        this.instances = instances;
    }
    getDesignSpace() {
        return ImpLib.Order.fromList("DesignSpace", this.axes.map(a => a.dim));
    }
}
exports.Table = Table;
//# sourceMappingURL=fvar.js.map