"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FallbackPropCreator = exports.CaseCreator = void 0;
function CaseCreator(typeTag, fn) {
    const CtorImpl = CaseCtorImpl(typeTag, fn);
    return Object.assign(CtorImpl, { Type: typeTag });
}
exports.CaseCreator = CaseCreator;
function CaseCtorImpl(typeTag, fn) {
    return function (...args) {
        initialize(this, typeTag, fn(...args));
    };
}
function initialize(obj, tag, props) {
    obj.type = tag;
    Object.assign(obj, props);
}
function FallbackPropCreator(fn) {
    return (props) => props || fn();
}
exports.FallbackPropCreator = FallbackPropCreator;
//# sourceMappingURL=index.js.map