import * as Ot from "@ot-builder/ot";
import { Data } from "@ot-builder/prelude";
import { CoordRectifier, GlyphReferenceRectifier, PointAttachmentRectifier } from "../../interface";
export type RStub<C> = {
    demand: C;
    fill(dst: C): void;
};
export declare function RStub<C>(demand: C, fill: (dst: C) => void): RStub<C>;
export declare function rectifyLookupList<L, A>(lookups: L[], alg: A, app: (lookup: L, alg: A) => RStub<L>): Map<L, L>;
declare abstract class RectifyGlyphCoordAlgBase<L extends Ot.GsubGpos.LookupProp> {
    protected readonly rg: GlyphReferenceRectifier;
    protected readonly rc: CoordRectifier;
    protected readonly rap: Data.Maybe<PointAttachmentRectifier>;
    constructor(rg: GlyphReferenceRectifier, rc: CoordRectifier, rap: Data.Maybe<PointAttachmentRectifier>);
    protected _cache: WeakMap<L, RStub<L>>;
    protected setMeta(props: Ot.GsubGpos.LookupProp, ret: Ot.GsubGpos.LookupProp): void;
    protected isValidMatchingSequence(match: ReadonlySet<Ot.Glyph>[]): boolean;
    protected processChainingRules(props: Ot.GsubGpos.ChainingProp<L>, ret: Ot.GsubGpos.ChainingProp<L>): void;
    process(lookup: L): RStub<L>;
    protected abstract processImpl(lookup: L): RStub<L>;
}
export declare class RectifyGsubGlyphCoordAlg extends RectifyGlyphCoordAlgBase<Ot.Gsub.Lookup> {
    protected processImpl(lookup: Ot.Gsub.Lookup): RStub<Ot.Gsub.Lookup>;
    private gsubSingle;
    private gsubMulti;
    private gsubAlternate;
    private gsubLigature;
    private gsubReverse;
    private gsubChaining;
}
export declare class RectifyGposGlyphCoordAlg extends RectifyGlyphCoordAlgBase<Ot.Gpos.Lookup> {
    protected processImpl(lookup: Ot.Gpos.Lookup): RStub<Ot.Gpos.Lookup>;
    gposSingle(props: Ot.Gpos.SingleProp): RStub<Ot.Gpos.Lookup>;
    gposPair(props: Ot.Gpos.PairProp): RStub<Ot.Gpos.Lookup>;
    gposCursive(props: Ot.Gpos.CursiveProp): RStub<Ot.Gpos.Lookup>;
    gposMarkToBase(props: Ot.Gpos.MarkToBaseProp): RStub<Ot.Gpos.Lookup>;
    gposMarkToMark(props: Ot.Gpos.MarkToMarkProp): RStub<Ot.Gpos.Lookup>;
    gposMarkToLigature(props: Ot.Gpos.MarkToLigatureProp): RStub<Ot.Gpos.Lookup>;
    gposChaining(props: Ot.Gpos.ChainingProp): RStub<Ot.Gpos.Lookup>;
}
export {};
//# sourceMappingURL=rectify.d.ts.map