'use strict';var _slicedToArray = function () {function sliceIterator(arr, i) {var _arr = [];var _n = true;var _d = false;var _e = undefined;try {for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {_arr.push(_s.value);if (i && _arr.length === i) break;}} catch (err) {_d = true;_e = err;} finally {try {if (!_n && _i["return"]) _i["return"]();} finally {if (_d) throw _e;}}return _arr;}return function (arr, i) {if (Array.isArray(arr)) {return arr;} else if (Symbol.iterator in Object(arr)) {return sliceIterator(arr, i);} else {throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();var _path = require('path');var _path2 = _interopRequireDefault(_path);
var _fs = require('fs');var _fs2 = _interopRequireDefault(_fs);
var _pkgUp = require('eslint-module-utils/pkgUp');var _pkgUp2 = _interopRequireDefault(_pkgUp);
var _minimatch = require('minimatch');var _minimatch2 = _interopRequireDefault(_minimatch);
var _resolve = require('eslint-module-utils/resolve');var _resolve2 = _interopRequireDefault(_resolve);
var _moduleVisitor = require('eslint-module-utils/moduleVisitor');var _moduleVisitor2 = _interopRequireDefault(_moduleVisitor);
var _importType = require('../core/importType');var _importType2 = _interopRequireDefault(_importType);
var _packagePath = require('../core/packagePath');
var _docsUrl = require('../docsUrl');var _docsUrl2 = _interopRequireDefault(_docsUrl);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { 'default': obj };}

var depFieldCache = new Map();

function hasKeys() {var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return Object.keys(obj).length > 0;
}

function arrayOrKeys(arrayOrObject) {
  return Array.isArray(arrayOrObject) ? arrayOrObject : Object.keys(arrayOrObject);
}

function readJSON(jsonPath, throwException) {
  try {
    return JSON.parse(_fs2['default'].readFileSync(jsonPath, 'utf8'));
  } catch (err) {
    if (throwException) {
      throw err;
    }
  }
}

function extractDepFields(pkg) {
  return {
    dependencies: pkg.dependencies || {},
    devDependencies: pkg.devDependencies || {},
    optionalDependencies: pkg.optionalDependencies || {},
    peerDependencies: pkg.peerDependencies || {},
    // BundledDeps should be in the form of an array, but object notation is also supported by
    // `npm`, so we convert it to an array if it is an object
    bundledDependencies: arrayOrKeys(pkg.bundleDependencies || pkg.bundledDependencies || []) };

}

function getPackageDepFields(packageJsonPath, throwAtRead) {
  if (!depFieldCache.has(packageJsonPath)) {
    var depFields = extractDepFields(readJSON(packageJsonPath, throwAtRead));
    depFieldCache.set(packageJsonPath, depFields);
  }

  return depFieldCache.get(packageJsonPath);
}

function getDependencies(context, packageDir) {
  var paths = [];
  try {
    var packageContent = {
      dependencies: {},
      devDependencies: {},
      optionalDependencies: {},
      peerDependencies: {},
      bundledDependencies: [] };


    if (packageDir && packageDir.length > 0) {
      if (!Array.isArray(packageDir)) {
        paths = [_path2['default'].resolve(packageDir)];
      } else {
        paths = packageDir.map(function (dir) {return _path2['default'].resolve(dir);});
      }
    }

    if (paths.length > 0) {
      // use rule config to find package.json
      paths.forEach(function (dir) {
        var packageJsonPath = _path2['default'].join(dir, 'package.json');
        var _packageContent = getPackageDepFields(packageJsonPath, true);
        Object.keys(packageContent).forEach(function (depsKey) {return (
            Object.assign(packageContent[depsKey], _packageContent[depsKey]));});

      });
    } else {
      var packageJsonPath = (0, _pkgUp2['default'])({
        cwd: context.getPhysicalFilename ? context.getPhysicalFilename() : context.getFilename(),
        normalize: false });


      // use closest package.json
      Object.assign(
      packageContent,
      getPackageDepFields(packageJsonPath, false));

    }

    if (![
    packageContent.dependencies,
    packageContent.devDependencies,
    packageContent.optionalDependencies,
    packageContent.peerDependencies,
    packageContent.bundledDependencies].
    some(hasKeys)) {
      return null;
    }

    return packageContent;
  } catch (e) {
    if (paths.length > 0 && e.code === 'ENOENT') {
      context.report({
        message: 'The package.json file could not be found.',
        loc: { line: 0, column: 0 } });

    }
    if (e.name === 'JSONError' || e instanceof SyntaxError) {
      context.report({
        message: 'The package.json file could not be parsed: ' + e.message,
        loc: { line: 0, column: 0 } });

    }

    return null;
  }
}

function missingErrorMessage(packageName) {
  return '\'' + String(packageName) + '\' should be listed in the project\'s dependencies. ' + ('Run \'npm i -S ' + String(
  packageName) + '\' to add it');
}

function devDepErrorMessage(packageName) {
  return '\'' + String(packageName) + '\' should be listed in the project\'s dependencies, not devDependencies.';
}

function optDepErrorMessage(packageName) {
  return '\'' + String(packageName) + '\' should be listed in the project\'s dependencies, ' + 'not optionalDependencies.';

}

function getModuleOriginalName(name) {var _name$split =
  name.split('/'),_name$split2 = _slicedToArray(_name$split, 2),first = _name$split2[0],second = _name$split2[1];
  return first.startsWith('@') ? String(first) + '/' + String(second) : first;
}

function getModuleRealName(resolved) {
  return (0, _packagePath.getFilePackageName)(resolved);
}

function checkDependencyDeclaration(deps, packageName, declarationStatus) {
  var newDeclarationStatus = declarationStatus || {
    isInDeps: false,
    isInDevDeps: false,
    isInOptDeps: false,
    isInPeerDeps: false,
    isInBundledDeps: false };


  // in case of sub package.json inside a module
  // check the dependencies on all hierarchy
  var packageHierarchy = [];
  var packageNameParts = packageName ? packageName.split('/') : [];
  packageNameParts.forEach(function (namePart, index) {
    if (!namePart.startsWith('@')) {
      var ancestor = packageNameParts.slice(0, index + 1).join('/');
      packageHierarchy.push(ancestor);
    }
  });

  return packageHierarchy.reduce(function (result, ancestorName) {
    return {
      isInDeps: result.isInDeps || deps.dependencies[ancestorName] !== undefined,
      isInDevDeps: result.isInDevDeps || deps.devDependencies[ancestorName] !== undefined,
      isInOptDeps: result.isInOptDeps || deps.optionalDependencies[ancestorName] !== undefined,
      isInPeerDeps: result.isInPeerDeps || deps.peerDependencies[ancestorName] !== undefined,
      isInBundledDeps:
      result.isInBundledDeps || deps.bundledDependencies.indexOf(ancestorName) !== -1 };

  }, newDeclarationStatus);
}

function reportIfMissing(context, deps, depsOptions, node, name) {
  // Do not report when importing types unless option is enabled
  if (
  !depsOptions.verifyTypeImports && (
  node.importKind === 'type' || node.importKind === 'typeof'))
  {
    return;
  }

  var typeOfImport = (0, _importType2['default'])(name, context);

  if (
  typeOfImport !== 'external' && (
  typeOfImport !== 'internal' || !depsOptions.verifyInternalDeps))
  {
    return;
  }

  var resolved = (0, _resolve2['default'])(name, context);
  if (!resolved) {return;}

  var importPackageName = getModuleOriginalName(name);
  var declarationStatus = checkDependencyDeclaration(deps, importPackageName);

  if (
  declarationStatus.isInDeps ||
  depsOptions.allowDevDeps && declarationStatus.isInDevDeps ||
  depsOptions.allowPeerDeps && declarationStatus.isInPeerDeps ||
  depsOptions.allowOptDeps && declarationStatus.isInOptDeps ||
  depsOptions.allowBundledDeps && declarationStatus.isInBundledDeps)
  {
    return;
  }

  // test the real name from the resolved package.json
  // if not aliased imports (alias/react for example), importPackageName can be misinterpreted
  var realPackageName = getModuleRealName(resolved);
  if (realPackageName && realPackageName !== importPackageName) {
    declarationStatus = checkDependencyDeclaration(deps, realPackageName, declarationStatus);

    if (
    declarationStatus.isInDeps ||
    depsOptions.allowDevDeps && declarationStatus.isInDevDeps ||
    depsOptions.allowPeerDeps && declarationStatus.isInPeerDeps ||
    depsOptions.allowOptDeps && declarationStatus.isInOptDeps ||
    depsOptions.allowBundledDeps && declarationStatus.isInBundledDeps)
    {
      return;
    }
  }

  if (declarationStatus.isInDevDeps && !depsOptions.allowDevDeps) {
    context.report(node, devDepErrorMessage(realPackageName || importPackageName));
    return;
  }

  if (declarationStatus.isInOptDeps && !depsOptions.allowOptDeps) {
    context.report(node, optDepErrorMessage(realPackageName || importPackageName));
    return;
  }

  context.report(node, missingErrorMessage(realPackageName || importPackageName));
}

function testConfig(config, filename) {
  // Simplest configuration first, either a boolean or nothing.
  if (typeof config === 'boolean' || typeof config === 'undefined') {
    return config;
  }
  // Array of globs.
  return config.some(function (c) {return (
      (0, _minimatch2['default'])(filename, c) ||
      (0, _minimatch2['default'])(filename, _path2['default'].join(process.cwd(), c)));});

}

module.exports = {
  meta: {
    type: 'problem',
    docs: {
      category: 'Helpful warnings',
      description: 'Forbid the use of extraneous packages.',
      url: (0, _docsUrl2['default'])('no-extraneous-dependencies') },


    schema: [
    {
      'type': 'object',
      'properties': {
        'devDependencies': { 'type': ['boolean', 'array'] },
        'optionalDependencies': { 'type': ['boolean', 'array'] },
        'peerDependencies': { 'type': ['boolean', 'array'] },
        'bundledDependencies': { 'type': ['boolean', 'array'] },
        'packageDir': { 'type': ['string', 'array'] },
        'includeInternal': { 'type': ['boolean'] },
        'includeTypes': { 'type': ['boolean'] } },

      'additionalProperties': false }] },




  create: function () {function create(context) {
      var options = context.options[0] || {};
      var filename = context.getPhysicalFilename ? context.getPhysicalFilename() : context.getFilename();
      var deps = getDependencies(context, options.packageDir) || extractDepFields({});

      var depsOptions = {
        allowDevDeps: testConfig(options.devDependencies, filename) !== false,
        allowOptDeps: testConfig(options.optionalDependencies, filename) !== false,
        allowPeerDeps: testConfig(options.peerDependencies, filename) !== false,
        allowBundledDeps: testConfig(options.bundledDependencies, filename) !== false,
        verifyInternalDeps: !!options.includeInternal,
        verifyTypeImports: !!options.includeTypes };


      return (0, _moduleVisitor2['default'])(function (source, node) {
        reportIfMissing(context, deps, depsOptions, node, source.value);
      }, { commonjs: true });
    }return create;}(),

  'Program:exit': function () {function ProgramExit() {
      depFieldCache.clear();
    }return ProgramExit;}() };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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