"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decideGlyphClass = exports.GlyphClass = void 0;
const ot_builder_1 = require("ot-builder");
var GlyphClass;
(function (GlyphClass) {
    GlyphClass[GlyphClass["NotDef"] = 0] = "NotDef";
    GlyphClass[GlyphClass["Space"] = 16] = "Space";
    GlyphClass[GlyphClass["PostSpacePad"] = 32] = "PostSpacePad";
    GlyphClass[GlyphClass["Normal"] = 48] = "Normal";
    GlyphClass[GlyphClass["KindMask"] = 48] = "KindMask";
    GlyphClass[GlyphClass["Simple"] = 2] = "Simple";
    GlyphClass[GlyphClass["CommonWidth"] = 4] = "CommonWidth";
    GlyphClass[GlyphClass["CommonHeight"] = 8] = "CommonHeight";
    GlyphClass[GlyphClass["VeryLast"] = 65535] = "VeryLast";
})(GlyphClass = exports.GlyphClass || (exports.GlyphClass = {}));
function decideGlyphClass(glyph, gid, commonWidth, commonHeight) {
    if (gid === 0)
        return GlyphClass.NotDef;
    if (!glyph.geometry)
        return GlyphClass.Space;
    let gk = GlyphClass.Normal;
    if (glyph.geometry.type === ot_builder_1.Ot.Glyph.GeometryType.ContourSet)
        gk |= GlyphClass.Simple;
    const advanceWidth = ot_builder_1.Ot.Var.Ops.minus(glyph.horizontal.end, glyph.horizontal.start);
    const advanceHeight = ot_builder_1.Ot.Var.Ops.minus(glyph.vertical.start, glyph.vertical.end);
    if (ot_builder_1.Ot.Var.Ops.originOf(advanceWidth) === commonWidth)
        gk |= GlyphClass.CommonWidth;
    if (ot_builder_1.Ot.Var.Ops.originOf(advanceHeight) === commonHeight)
        gk |= GlyphClass.CommonHeight;
    return gk;
}
exports.decideGlyphClass = decideGlyphClass;
//# sourceMappingURL=glyph-class.js.map