import { Point } from "./base";
import { SpiroArc } from "./spiro-arc";
export interface IArcContext {
    beginShape(): void;
    endShape(): void;
    moveTo(x: number, y: number): void;
    arcTo(arc: SpiroArc, x: number, y: number, isStraight: boolean): void;
}
export declare class SimplyCollectArcContext implements IArcContext {
    arcs: SpiroArc[];
    beginShape(): void;
    endShape(): void;
    moveTo(): void;
    arcTo(arc: SpiroArc): void;
}
export interface IBezierContext {
    beginShape(): void;
    endShape(): void;
    moveTo(x: number, y: number): void;
    lineTo(x: number, y: number): void;
    cubicTo(x1: number, y1: number, x2: number, y2: number, x: number, y: number): void;
}
export declare type KnotCallback<C> = (this: C, x0: number, y0: number, x1?: number, y1?: number) => void;
export declare type LineArc = {
    order: 1;
    start: Point;
    end: Point;
};
export declare type QuadArc = {
    order: 2;
    start: Point;
    c1: Point;
    end: Point;
};
export declare type CubeArc = {
    order: 3;
    start: Point;
    c1: Point;
    c2: Point;
    end: Point;
};
export declare type Arc = LineArc | QuadArc | CubeArc;
export declare class DefaultBezierContext implements IBezierContext {
    strands: Arc[];
    lastx: number;
    lasty: number;
    beginShape(): void;
    endShape(): void;
    moveTo(x: number, y: number): void;
    lineTo(x: number, y: number): void;
    curveTo(x1: number, y1: number, x: number, y: number): void;
    cubicTo(x1: number, y1: number, x2: number, y2: number, x: number, y: number): void;
}
